@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.my_profile'))

@section('content')
  <div class="row">
    <div class="col-lg-4">
      <div class="card card-user">
        <div class="image">
          <img src="" alt="">
        </div>
        <div class="card-body">
          <div class="author">
            <img class="avatar border-gray" src="{{ $user->avatar }}" alt="">
            <h5 class="title">{{ $user->full_name }}</h5>
            <p class="text-muted small">
              <i>{{ $user->accountTypeFormatted }}</i>
            </p>
            @if (!$user->isIndividual)
              <p class="text-muted">
                « {{ $user->organizationName }} »
              </p>
            @endif
          </div>
          @if (!$user->isOrganizationAccess)
            <div class="row">
              <div class="ml-auto mr-auto">
                <a class="btn btn-primary btn-round"
                  href="{{ route('delete-account.request') }}">{{ __('messages.global.delete_my_account') }}</a>
              </div>
            </div>
          @endif
        </div>
      </div>
    </div>
    <div class="col-lg-8 order-first">

      <div class="card card-user">
        <div class="card-header">
          <h5 class="card-title">{{ __('messages.global.edit_profile') }}</h5>
        </div>
        <div class="card-body">

          <form enctype="multipart/form-data" method="post" action="{{ route('user.profile.update') }}">
            {{-- CSRF --}}
            {{ csrf_field() }}

            @if ($user->isOrganization)
              <div class="row">
                {{-- Organization Name Field --}}
                <div class="col-md-4">
                  <div class="form-group">
                    <label>{{ __('messages.global.organization_name') }}</label>
                    <input type="organization_name" class="form-control" disabled="disabled"
                      placeholder="{{ __('messages.global.organization_name') }}"
                      value="{{ $user->organization_name }}">
                  </div>
                </div>
                {{-- Organization Number Field --}}
                <div class="col-md-4">
                  <div class="form-group">
                    <label>{{ __('messages.global.organization_number') }}</label>
                    <input type="organization_number" class="form-control" disabled="disabled"
                      placeholder="{{ __('messages.global.organization_number') }}"
                      value="{{ $user->organization_number }}">
                  </div>
                </div>
                {{-- Organization Function Field --}}
                <div class="col-md-4">
                  <div class="form-group">
                    <label>{{ __('messages.global.organization_function') }}</label>
                    <input type="organization_function" name="organization_function" class="form-control"
                      placeholder="{{ __('messages.global.organization_function') }}" maxlength="30"
                      value="{{ old('organization_function', $user->organization_function) }}">
                    @if ($errors->has('organization_function'))
                      <span class="small text-danger">{{ $errors->first('organization_function') }}</span>
                    @endif
                  </div>
                </div>
              </div>
            @endif

            <div class="row">
              {{-- Email Field --}}
              <div class="col-md-5">
                <div class="form-group">
                  <label>{{ __('messages.global.email_address') }}</label>
                  <input type="email" class="form-control" disabled="disabled"
                    placeholder="{{ __('messages.global.email_address') }}" value="{{ $user->email }}">
                </div>
              </div>
              {{-- First Name Field --}}
              <div class="col-md-3">
                <div class="form-group">
                  <label for="first_name">{{ __('messages.global.first_name') }}</label>
                  <input type="text" name="first_name" class="form-control"
                    placeholder="{{ __('messages.global.first_name') }}" maxlength="60"
                    value="{{ old('first_name', $user->first_name) }}" required
                    @if ($user->isOrganizationAccess) disabled="disabled" @endif>
                  @if ($errors->has('first_name'))
                    <span class="small text-danger">{{ $errors->first('first_name') }}</span>
                  @endif
                </div>
              </div>
              {{-- Last Name Field --}}
              <div class="col-md-4">
                <div class="form-group">
                  <label for="last_name">{{ __('messages.global.last_name') }}</label>
                  <input type="text" name="last_name" class="form-control"
                    placeholder="{{ __('messages.global.last_name') }}" maxlength="60"
                    value="{{ old('last_name', $user->last_name) }}" required
                    @if ($user->isOrganizationAccess) disabled="disabled" @endif>
                  @if ($errors->has('last_name'))
                    <span class="small text-danger">{{ $errors->first('last_name') }}</span>
                  @endif
                </div>
              </div>
            </div>

            @if (!$user->isOrganizationAccess)
              <div class="row">
                {{-- Phone Field --}}
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="phone">{{ __('messages.global.phone_number') }}</label>
                    <input type="text" id="phone" name="phone" class="form-control" disabled="disabled"
                      placeholder="{{ __('messages.global.phone_number') }}"
                      value="{{ old('phone', $user->phone) }}">
                    <div class="custom-control custom-switch mt-2">
                      <input type="checkbox" class="custom-control-input" id="phone-is-private" name="phone_is_private"
                        @if (old('phone_is_private', $user->phone_is_private)) checked @endif>
                      <label class="custom-control-label" for="phone-is-private">Privé</label>
                    </div>
                    @if ($errors->has('phone'))
                      <span class="small text-danger">{{ $errors->first('phone') }}</span>
                    @endif
                  </div>
                </div>

                {{-- Address Field --}}
                <div class="col-md-9">
                  <div class="form-group">
                    <label for="address">{{ __('messages.global.address') }}</label>
                    <input type="text" id="address" name="address" class="form-control"
                      placeholder="{{ __('messages.global.address') }}"
                      value="{{ old('address', $user->address) }}" onFocus="geolocate()"
                      {{ $user->hasAddress() ? 'disabled="disabled"' : '' }}>
                    <input type="hidden" id="location_latitude" name="location_latitude"
                      value="{{ old('location_latitude', $user->location_latitude) }}">
                    <input type="hidden" id="location_longitude" name="location_longitude"
                      value="{{ old('location_longitude', $user->location_longitude) }}">
                    <input type="hidden" id="location_zipcode" name="location_zipcode"
                      value="{{ old('location_zipcode', $user->location_zipcode) }}">
                    <input type="hidden" id="location_country" name="location_country"
                      value="{{ old('location_country', $user->location_country) }}">
                    @if ($errors->has('address'))
                      <span class="small text-danger">{{ $errors->first('address') }}</span>
                    @endif
                  </div>
                </div>
              </div>

              <div class="row">
                {{-- Gender Field --}}
                <div class="col-md-6">
                  <div class="mb-6">
                    <div class="form-group">
                      <label for="gender">{{ __('messages.global.gender') }}</label>
                      <select id="gender" name="gender" class="custom-select"
                        placeholder="{{ __('messages.global.gender') }}">
                        <option value="">-</option>
                        @foreach ($genders as $gender)
                          <option value="{{ $gender }}"
                            {{ old('gender', $user->gender) == $gender ? 'selected' : '' }}>
                            {{ __('messages.gender.' . $gender) }}
                          </option>
                        @endforeach
                      </select>
                      @if ($errors->has('gender'))
                        <span class="small text-danger">{{ $errors->first('gender') }}</span>
                      @endif
                    </div>
                  </div>
                </div>

                {{-- Date of birth Field --}}
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="firstname">{{ __('messages.global.date_of_birth') }}</label>
                    <input type="text" name="date_of_birth" class="form-control"
                      placeholder="{{ __('messages.global.date_of_birth') }}"
                      value="{{ old('date_of_birth', $user->date_of_birth) }}">
                    @if ($errors->has('date_of_birth'))
                      <span class="small text-danger">{{ $errors->first('date_of_birth') }}</span>
                    @endif
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="update ml-auto mr-auto">
                  <button type="submit" name="update-profile"
                    class="btn btn-primary btn-round">{{ __('messages.global.update') }}</button>
                </div>
              </div>
            @endif
          </form>
        </div>
      </div>
    </div>
  </div>
@endsection


@section('js')
  <script>
    // Autocompletion for address field
    var placeSearch, autocomplete;

    function initAutocomplete() {
      autocomplete = new google.maps.places.Autocomplete(
        document.getElementById('address'), {
          types: ['address']
        });

      autocomplete.setFields(['geometry', 'address_components']);
      autocomplete.addListener('place_changed', fillInAddress);
    }

    function fillInAddress() {
      var place = autocomplete.getPlace();
      var zipcode = '';
      var country = '';

      for (var i = 0; i < place.address_components.length; i++) {
        var addressType = place.address_components[i].types[0];

        if (addressType == 'postal_code') {
          zipcode = place.address_components[i]['short_name'];
        }
        if (addressType == 'country') {
          country = place.address_components[i]['short_name'];
        }
      }

      document.getElementById('location_latitude').value = place.geometry.location.lat();
      document.getElementById('location_longitude').value = place.geometry.location.lng();
      document.getElementById('location_zipcode').value = zipcode;
      document.getElementById('location_country').value = country;
    }

    // Bias the autocomplete object to the user's geographical location,
    // as supplied by the browser's 'navigator.geolocation' object.
    function geolocate() {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
          var geolocation = {
            lat: position.coords.latitude,
            lng: position.coords.longitude
          };
          var circle = new google.maps.Circle({
            center: geolocation,
            radius: position.coords.accuracy
          });
          autocomplete.setBounds(circle.getBounds());
        });
      }
    }
  </script>

  <script
    src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.api_key') }}&libraries=places&callback=initAutocomplete"
    async defer></script>
@endsection
