@extends('landing::_layouts.master')

@section('title', __('messages.global.login'))

@section('content')


  {{-- Header --}}
  <header class="pt-24">
    <div class="mx-auto container px-3 py-16">
      <div class="w-full text-center">
        <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.user_area') }}</h1>
      </div>
    </div>
  </header>

  {{-- Starting gradient --}}
  @include('landing::_layouts/_partials/gradient-start', ['fill' => '#ffffff'])


  {{-- Content --}}
  <section class="bg-white py-16 mx-auto">
    <div class="mx-auto container">

      {{-- Flash Messages --}}
      @if (session('resent_code'))
        <div
          class="mx-auto w-full lg:w-1/2 bg-teal-100 border-t-4 border-teal-500 rounded-xl text-teal-900 px-4 py-3 mb-4 shadow"
          role="alert">
          <div class="text-center">
            <div>
              <p class="mx-auto font-bold">{{ __('messages.has_verified_phone.resent') }}</p>
              <p class="text-sm">&nbsp;</p>
            </div>
          </div>
        </div>
      @endif

      {{-- Title --}}
      <div class="mx-auto text-center flex flex-wrap">
        <div class=" mx-auto mb-16">
          <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">
            {{ __('messages.has_verified_phone.please_verify') }}</h1>
          <div class="w-full mt-4">
            <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
          </div>
        </div>
      </div>

      {{-- Form --}}
      <div class="mx-auto text-center text-black text-xl flex">
        <form method="post" action="{{ route('verification_phone.verify') }}"
          class="mx-auto bg-white shadow rounded-xl px-6 py-6">
          {{-- CSRF --}}
          @csrf

          {{-- Phone Field --}}
          <div class="mb-6 text-left">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="phone">
              {{ __('messages.global.phone_number') }}
            </label>
            <input type="text" name="phone" value="{{ old('phone') ?? auth()->user()->phone }}"
              placeholder="{{ __('messages.global.phone_number') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('phone'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('phone') }}</p>
            @endif
          </div>

          {{-- Verification Code Field --}}
          <div class="mb-6 text-left">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="verification_code">
              {{ __('messages.global.verification_code') }}
            </label>
            <input type="text" name="verification_code" value="{{ old('verification_code') }}"
              placeholder="{{ __('messages.global.verification_code') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('verification_code'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('verification_code') }}</p>
            @endif
          </div>

          {{-- Resend link --}}
          <div class="mt-6 mb-6 text-center">
            <button type="button" value="resend" data-action="{{ route('verification_phone.resend') }}"
              class="text-gray-600 rounded-full mt-4 lg:mt-4 py-4 px-8">
              {{ __('messages.has_verified_phone.resend') }}
            </button>
          </div>

          {{-- Submit --}}
          <button type="button" value="submit" data-action="{{ route('verification_phone.verify') }}"
            class="gradient text-white font-bold rounded-full mt-4 lg:mt-0 py-4 px-8 opacity-75 hover:opacity-100 shadow">
            {{ __('messages.global.validate') }}
          </button>

          {{-- Logout link --}}
          <div class="mt-6 text-center">
            <a href="{{ route('user.auth.logout') }}"
              class="text-orange-500 font-bold rounded-full mt-4 lg:mt-4 py-4 px-8">
              {{ __('messages.global.logout') }}
            </a>
          </div>
        </form>
      </div>

    </div>
  </section>


  {{-- Ending gradient --}}
  @include('landing::_layouts/_partials/gradient-end', ['fill' => '#ffffff'])

@endsection


@section('js')
  <script>
    $("form button").click(function(ev) {
      ev.preventDefault();
      if ($(this).attr("value") == "resend" || $(this).attr("value") == "submit") {
        $("form").attr("action", $(this).attr("data-action"));
      }
      $("form").submit();
    });
  </script>
@endsection
