@extends('landing::_layouts.master')

@section('title', __('messages.global.login'))

@section('content')


{{-- Header --}}
<header class="pt-24">
  <div class="mx-auto container px-3 py-16">
    <div class="w-full text-center">
      <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.user_area') }}</h1>
    </div>
  </div>
</header>


{{-- Starting gradient --}}
@include('landing::_layouts/_partials/gradient-start', ['fill' => '#ffffff'])


{{-- Content --}}
<section class="bg-white py-16 mx-auto">
  <div class="mx-auto container">

    {{-- Flash Messages --}}
    @if (session('resent'))
    <div class="mx-auto w-full lg:w-1/2 bg-teal-100 border-t-4 border-teal-500 rounded-xl text-teal-900 px-4 py-3 mb-4 shadow" role="alert">
      <div class="text-center">
        <div>
          <p class="mx-auto font-bold">{{ __('messages.has_verified_email.resent') }}</p>
          <p class="text-sm">&nbsp;</p>
        </div>
      </div>
    </div>
    @endif

    {{-- Title --}}
    <div class="mx-auto text-center flex flex-wrap">
      <div class=" mx-auto mb-16">
        <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">{{ __('messages.has_verified_email.please_verify') }}</h1>
        <div class="w-full mt-4">
          <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
        </div>
      </div>
    </div>

    {{-- Content --}}
    <div class="mx-auto text-center">
      <form class="form" method="post" action="{{ route('verification.resend') }}">
        @csrf
        <input type="submit" value="{{ __('messages.has_verified_email.resend') }}" class="gradient text-white font-bold rounded-full mt-4 lg:mt-0 py-4 px-8 opacity-75 hover:opacity-100 shadow">
      </form>

      <div class="mt-6">
        <a href="{{ route('user.auth.logout') }}" class="text-orange-500 font-bold rounded-full mt-4 lg:mt-4 py-4 px-8">
          {{ __('messages.global.logout') }}
        </a>
      </div>

    </div>

  </div>
</section>


{{-- Ending gradient --}}
@include('landing::_layouts/_partials/gradient-end', ['fill' => '#ffffff'])


@endsection
