<section class="bg-gray-100 py-16 mx-auto">
  <div class="mx-auto container">

    {{-- Title --}}
    <div class="mx-auto text-center flex flex-wrap">
      <div class=" mx-auto mb-16">
        <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">{{ __('messages.global.register') }}
        </h1>
        <div class="w-full mt-4">
          <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
        </div>
      </div>
    </div>

    {{-- Form --}}
    <div class="mx-auto text-left text-black text-xl flex">
      <form method="post" action="{{ route('user.auth.register') }}"
        class="mx-auto bg-white shadow rounded-xl px-6 py-6">
        {{-- CSRF --}}
        @csrf

        {{-- Account Type Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="account_type">
            {{ __('messages.global.account_type') }} <span class="text-red-500">*</span>
          </label>
          <select id="account_type" name="account_type"
            class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            <option value="{{ Modules\Common\Entities\User::ACCOUNT_TYPE_INDIVIDUAL }}"
              {{ old('account_type') == Modules\Common\Entities\User::ACCOUNT_TYPE_INDIVIDUAL ? 'selected' : '' }}>
              {{ __('messages.account_type.individual') }}
            </option>
            <option value="{{ Modules\Common\Entities\User::ACCOUNT_TYPE_ORGANIZATION }}"
              {{ old('account_type') == Modules\Common\Entities\User::ACCOUNT_TYPE_ORGANIZATION ? 'selected' : '' }}>
              {{ __('messages.account_type.organization') }}
            </option>
          </select>
          @if ($errors->has('account_type'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('account_type') }}</p>
          @endif
        </div>

        {{-- First Name Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="first_name">
            {{ __('messages.global.first_name') }} <span class="text-red-500">*</span>
          </label>
          <input type="text" name="first_name" value="{{ old('first_name') }}"
            placeholder="{{ __('messages.global.first_name') }}" maxlength="60"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('first_name'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('first_name') }}</p>
          @endif
        </div>

        {{-- Last Name Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="last_name">
            {{ __('messages.global.last_name') }} <span class="text-red-500">*</span>
          </label>
          <input type="text" name="last_name" value="{{ old('last_name') }}"
            placeholder="{{ __('messages.global.last_name') }}" maxlength="60"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('last_name'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('last_name') }}</p>
          @endif
        </div>

        {{-- Address Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="address">
            {{ __('messages.global.address') }} <span class="text-red-500">*</span>
          </label>
          <input type="text" id="address" name="address" value="{{ old('address') }}" onFocus="geolocate()"
            placeholder="{{ __('messages.global.click_on_the_proposal') }}" maxlength="180"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          <input type="hidden" id="location_latitude" name="location_latitude" value="{{ old('location_latitude') }}">
          <input type="hidden" id="location_longitude" name="location_longitude"
            value="{{ old('location_longitude') }}">
          <input type="hidden" id="location_zipcode" name="location_zipcode" value="{{ old('location_zipcode') }}">
          <input type="hidden" id="location_country" name="location_country" value="{{ old('location_country') }}">
          @if ($errors->has('address'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('address') }}</p>
          @elseif ($errors->has('location_latitude'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('location_latitude') }}</p>
          @elseif ($errors->has('location_longitude'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('location_longitude') }}</p>
          @elseif ($errors->has('location_zipcode'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('location_zipcode') }}</p>
          @elseif ($errors->has('location_country'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('location_country') }}</p>
          @endif
        </div>

        {{-- Gender Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="gender">
            {{ __('messages.global.gender') }}
          </label>
          <select id="gender" name="gender"
            class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            <option value="">-</option>
            <option value="{{ Modules\Common\Entities\User::GENDER_MALE }}"
              {{ old('gender') == Modules\Common\Entities\User::GENDER_MALE ? 'selected' : '' }}>
              {{ __('messages.gender.m') }}
            </option>
            <option value="{{ Modules\Common\Entities\User::GENDER_FEMALE }}"
              {{ old('gender') == Modules\Common\Entities\User::GENDER_FEMALE ? 'selected' : '' }}>
              {{ __('messages.gender.f') }}
            </option>
          </select>
          @if ($errors->has('gender'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('gender') }}</p>
          @endif
        </div>

        {{-- Date of birth Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="date_of_birth">
            {{ __('messages.global.date_of_birth') }}
          </label>
          <input type="text" name="date_of_birth" value="{{ old('date_of_birth') }}" placeholder="Ex: 1980-06-26"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('date_of_birth'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('date_of_birth') }}</p>
          @endif
        </div>

        {{-- Phone Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="phone">
            {{ __('messages.global.phone_number') }} (mobile) <span class="text-red-500">*</span>
          </label>
          <input type="text" name="phone" value="{{ old('phone') }}" placeholder="Ex: +32497114045"
            maxlength="20"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('phone'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('phone') }}</p>
          @endif
        </div>

        {{-- Email Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="email">
            {{ __('messages.global.email_address') }} <span class="text-red-500">*</span>
          </label>
          <input type="text" name="email" value="{{ old('email') }}"
            placeholder="{{ __('messages.global.email_address') }}" maxlength="180"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('email'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('email') }}</p>
          @endif
        </div>

        {{-- Password Field --}}
        <div class="mb-6" x-data="{ show: true }">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="password">
            {{ __('messages.global.password') }} <span class="text-red-500">*</span>
          </label>
          <div class="relative">
            <input :type="show ? 'password' : 'text'" name="password" value="{{ old('password') }}"
              placeholder="{{ __('messages.global.password') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            <div class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5">
              <i @click="show = !show" :class="{ 'hidden': !show, 'fa fa-eye text-gray-700': show }"></i>
              <i @click="show = !show" :class="{ 'fa fa-eye-slash text-gray-700': !show, 'hidden': show }"></i>
            </div>
          </div>
          @if ($errors->has('password'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('password') }}</p>
          @endif
        </div>

        {{-- Organization Function Field --}}
        <div id="organization_function" class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="organization_function">
            {{ __('messages.global.organization_function') }} <span class="text-red-500">*</span>
          </label>
          <input type="text" name="organization_function" value="{{ old('organization_function') }}"
            placeholder="{{ __('messages.global.organization_function') }}" maxlength="30"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('organization_function'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('organization_function') }}</p>
          @endif
        </div>

        {{-- Organization Name Field --}}
        <div id="organization_name" class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="organization_name">
            {{ __('messages.global.organization_name') }} <span class="text-red-500">*</span>
          </label>
          <input type="text" name="organization_name" value="{{ old('organization_name') }}"
            placeholder="{{ __('messages.global.organization_name') }}" maxlength="30"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('organization_name'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('organization_name') }}</p>
          @endif
        </div>

        {{-- Organization Number Field --}}
        <div id="organization_number" class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="organization_number">
            {{ __('messages.global.organization_number') }} <span class="text-red-500">*</span>
          </label>
          <input type="text" name="organization_number" value="{{ old('organization_number') }}"
            placeholder="{{ __('messages.global.organization_number') }}" maxlength="30"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('organization_number'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('organization_number') }}</p>
          @endif
        </div>

        {{-- OptIn Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2">
            <input type="checkbox" name="opt_in" class="leading-tight">
            <span>{!! __('messages.register.optin', ['url' => route('landing.terms.index')]) !!}</span> <span class="text-red-500">*</span>
          </label>
          @if ($errors->has('opt_in'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('opt_in') }}</p>
          @endif
        </div>

        <div class="flex items-center justify-between space-x-4">
          {{-- Submit Button --}}
          <button type="submit"
            class="mx-auto gradient text-white font-bold rounded-full py-2 px-4 opacity-75 hover:opacity-100 shadow">
            {{ __('messages.global.signup') }}
          </button>
        </div>
      </form>
    </div>

  </div>
</section>

@section('js')
  <script type="text/javascript">
    showRegisterForm();
    $("#account_type").change(function() {
      showRegisterForm();
    });

    function showRegisterForm() {
      var organizationValue = "{{ Modules\Common\Entities\User::ACCOUNT_TYPE_ORGANIZATION }}";
      var isOrganization = $("#account_type").val() == organizationValue;
      if (isOrganization) {
        showOrganizationForm();
      } else {
        showIndividualForm();
      }
    }

    function showIndividualForm() {
      $("#organization_function").hide();
      $("#organization_name").hide();
      $("#organization_number").hide();
    }

    function showOrganizationForm() {
      $("#organization_function").show();
      $("#organization_name").show();
      $("#organization_number").show();
    }
  </script>

  <script>
    // Autocompletion for address field
    var placeSearch, autocomplete;

    function initAutocomplete() {
      autocomplete = new google.maps.places.Autocomplete(
        document.getElementById('address'), {
          types: ['address']
        });

      autocomplete.setFields(['geometry', 'address_components']);
      autocomplete.addListener('place_changed', fillInAddress);
    }

    function fillInAddress() {
      var place = autocomplete.getPlace();
      var zipcode = '';
      var country = '';

      for (var i = 0; i < place.address_components.length; i++) {
        var addressType = place.address_components[i].types[0];

        if (addressType == 'postal_code') {
          zipcode = place.address_components[i]['short_name'];
        }
        if (addressType == 'country') {
          country = place.address_components[i]['short_name'];
        }
      }

      document.getElementById('location_latitude').value = place.geometry.location.lat();
      document.getElementById('location_longitude').value = place.geometry.location.lng();
      document.getElementById('location_zipcode').value = zipcode;
      document.getElementById('location_country').value = country;
    }

    // Bias the autocomplete object to the user's geographical location,
    // as supplied by the browser's 'navigator.geolocation' object.
    function geolocate() {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
          var geolocation = {
            lat: position.coords.latitude,
            lng: position.coords.longitude
          };
          var circle = new google.maps.Circle({
            center: geolocation,
            radius: position.coords.accuracy
          });
          autocomplete.setBounds(circle.getBounds());
        });
      }
    }
  </script>

  <script
    src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.api_key') }}&libraries=places&callback=initAutocomplete"
    async defer></script>
@endsection
