@if (Session::has('resent') && Session::get('resent'))
  <div class="alert alert-success alert-dismissable fade show">
    <button type="button" class="close" data-dismiss="alert">
      <i class="fa fa-times"></i>
    </button>
    <b>{{ __('messages.has_verified_email.resent') }}</b>
  </div>
@endif

@if (Session::has('verified') && Session::get('verified'))
  <div class="alert alert-success alert-dismissable fade show">
    <button type="button" class="close" data-dismiss="alert">
      <i class="fa fa-times"></i>
    </button>
    <b>{{ __('messages.has_verified_email.verified') }}</b>
  </div>
@endif

@if (!$user->hasVerifiedEmail())
  <div class="alert alert-warning fade show">
    <span>
      <b>{{ __('messages.has_verified_email.not_verified') }}</b>
      <br>
      {{ __('messages.has_verified_email.please_verify') }}
      <br>
      <form method="post" action="{{ route('verification.resend') }}">
        {{ csrf_field() }}
        <input type="submit" class="btn btn-warning" value="{{ __('messages.has_verified_email.resend') }}">
      </form>
    </span>
  </div>
@endif
