<script src="https://unpkg.com/dropzone@5/dist/min/dropzone.min.js"></script>
<script>
  var uploadedDocumentMap = {}
  Dropzone.options.dropzone = {
    url: "{{ route('user.media.store') }}",
    paramName: "image",
    addRemoveLinks: true,
    acceptedFiles: "image/jpeg",
    maxFiles: 3,
    maxFilesize: 15,
    headers: {
      'X-CSRF-TOKEN': "{{ csrf_token() }}"
    },

    success: function(file, response) {
      $('form').append('<input type="hidden" name="images[]" value="' + response.name + '">')
      uploadedDocumentMap[file.upload.uuid] = response.name;
    },

    maxfilesexceeded: function(file) {
      this.removeFile(file);
    },

    removedfile: function(file) {
      file.previewElement.remove()
      var name = ''
      if (typeof file.upload !== 'undefined') {
        name = uploadedDocumentMap[file.upload.uuid]
      } else {
        name = file.name
      }
      $('form').find('input[name="images[]"][value="' + name + '"]').remove()
    },

    init: function() {
      @if (isset($thumbnails))
        var files = {!! json_encode($thumbnails) !!}
        for (var i in files) {
          var file = files[i]
          this.displayExistingFile({
            name: file.name,
            size: file.size
          }, file.url)
          $('form').append('<input type="hidden" name="images[]" value="' + file.name + '">')
        }
      @endif
    },

    dictDefaultMessage: "{{ __('Drop files here to upload') }}",
    dictInvalidFileType: "{{ __('You can\'t upload files of this type.') }}",
    dictCancelUpload: "{{ __('Cancel upload') }}",
    dictCancelUploadConfirmation: "{{ __('Are you sure you want to cancel this upload?') }}",
    dictRemoveFile: "{{ __('Remove file') }}",
    dictMaxFilesExceeded: "{{ __('You can not upload any more files.') }}",
  };
</script>
