<?php

namespace Modules\User\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\HtmlString;

use Modules\Common\Entities\User;


class MemberCredentialsNotification extends Notification
{
    use Queueable;

    /**
     * Attributes
     */
    protected $user;
    protected $password;
    protected $organization;


    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(User $user, String $password, String $organization)
    {
        $this->user = $user;
        $this->password = $password;
        $this->organization = $organization;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {

        return (new MailMessage)
            ->subject(__('Access to the organization', ['organization' => $this->organization]))
            ->line(__('Use the login details below to log into organization account', ['organization' => $this->organization]))
            ->line(new HtmlString(__('member_credentials_notification.credentials', [
                'email' => $this->user->email,
                'password' => $this->password,
            ])))
            ->action(__('Log in'), route('user.auth.login'));
    }

    // End of class
}
