<?php

namespace Modules\User\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Modules\Common\Entities\User;


class MemberUpdateRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'first_name' => ['required', 'regex:/^[\pL\s\-]+$/u', 'max:30'],
            'last_name'  => ['required', 'regex:/^[\pL\s\-]+$/u', 'max:30'],
        ];
    }

    public function attributes()
    {
        return [
            //
        ];
    }

    // End of class
}
