<?php

namespace Modules\User\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

use Auth;


class Premium
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if auth user is premium
        if (!Auth::user()->is_premium) {
            return $request->expectsJson()
                ? response(['message' => __('auth.account_not_premium'), 'error' => 'account_not_premium'], 403)
                : redirect()->route('user.profile.index');
        }

        return $next($request);
    }

    // End of class
}
