<?php

namespace Modules\User\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

use Auth;


class OrganizationVerified
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if auth user has organization verified
        if (!Auth::user()->is_verified) {
            return $request->expectsJson()
                ? response(['message' => __('auth.organization_not_verified'), 'error' => 'organization_not_verified'], 403)
                : redirect()->route('user.profile.index');
        }

        return $next($request);
    }

    // End of class
}
