<?php

namespace Modules\User\Http\Controllers\Traits;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Spatie\MediaLibrary\Models\Media;


trait ImagesUploadable
{

    /***************************************************************************
     * Methods
     **************************************************************************/
    protected function handleImages(Request $request, $model)
    {
        // Get images
        $images = $request->get('images');

        // Delete images not needed anymore
        foreach ($model->getMedia() as $media) {
            if (!in_array($media->file_name, $images)) {
                $media->delete();
            }
        }

        // Store new images
        foreach ($images as $image) {
            // Sanitize filename
            $filename = basename($image);

            // If image is temp
            if ($this->isTemporaryImage($filename)) {
                $file = Storage::disk('tmp')->path($filename);
                $this->addMediaToModel($model, $file);
                Storage::disk('tmp')->delete($filename); // Delete temp file
            }
            // If image is not temp
            else {
                $mediaNames = $model->getMedia()->pluck('file_name')->toArray();
                if (!in_array($filename, $mediaNames)) {
                    $media = Media::where('file_name', $filename)->first();
                    if ($media) {
                        $file = $media->getPath();
                        try {
                            $media->copy($model);
                        } catch (\Throwable $e) {
                        }
                    }
                }
            }
        }
    }

    /***************************************************************************
     * Utils
     **************************************************************************/
    private function isTemporaryImage($filename)
    {
        return Storage::disk('tmp')->exists($filename);
    }

    private function addMediaToModel($model, $file)
    {
        $filename = uniqid() . '.jpg';
        $model->addMedia($file)
            ->usingFileName($filename)
            ->toMediaCollection();
    }

    // End of class
}
