<?php

namespace Modules\User\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Common\Entities\Animal;
use Modules\Common\Entities\Report;
use Modules\Common\Http\Requests\FoundReportStoreRequest;
use Modules\User\Http\Controllers\Traits\ImagesUploadable;


class FoundReportController extends AuthenticatedController
{
    use ImagesUploadable;

    public function create(Request $request)
    {
        // Get user
        $user = $request->user();

        // Get values
        $animalSpecies = Animal::getAnimalSpeciesList();
        $animalConditions = Animal::ANIMAL_CONDITIONS;
        $identificationTypes = Animal::IDENTIFICATION_TYPES;

        // Return View
        return view('user::found_reports.create', compact(
            'animalSpecies',
            'animalConditions',
            'identificationTypes',
        ));
    }

    public function store(FoundReportStoreRequest $request)
    {
        // Create resource
        $validated = $request->validated();
        $validated['type'] = Report::TYPE_FOUND;
        $report = auth()->user()->reports()->create($validated);

        // Set expiration
        $report->setExpiration();

        // Handle images
        $this->handleImages($request, $report);

        // Refresh resource
        $report->refresh();

        // Handle notifies
        $report->handleNotifies(true);

        // Redirect
        return redirect()
            ->route('user.reports.index')
            ->with('success', __('messages.create_report.success'));
    }

    // End of class
}
