<?php

namespace Modules\User\Http\Controllers;

use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Modules\Common\Entities\User;
use Auth;


class DeleteAccountController extends AuthenticatedController
{

    public function showLinkRequestForm()
    {
        return view('user::delete-account.email');
    }

    public function sendDeleteLinkEmail(Request $request)
    {
        $request->user()->sendDeleteAccountConfirmationNotification();

        return $request->wantsJson()
            ? new Response('', 204)
            : redirect(route('user.profile.index'))->with('delete_account.resent', true);
    }

    public function delete($userId, Request $request)
    {
        $user = User::findOrFail($userId);

        if (!$request->hasValidSignature()) {
            throw new AuthorizationException(__('messages.delete_account.link_expired'));
        }

        $user->delete();

        return $request->wantsJson()
            ? new Response('', 204)
            : redirect(route('user.auth.login'))->with('delete_account.deleted', true);
    }

    // End of class
}
