<?php

namespace Modules\User\Http\Controllers\Auth;

use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Validation\Rule;
use Modules\Common\Entities\User;

class ResetPasswordController extends Controller
{
    /*
      |-------------------------------------------------------------------------
      | Password Reset Controller
      |-------------------------------------------------------------------------
      |
      | This controller is responsible for handling password reset requests
      | and uses a simple trait to include this behavior. You're free to
      | explore this trait and override any methods you wish to tweak.
      |
     */

    use ResetsPasswords;

    public function __construct()
    {
        $this->middleware('guest:user');
    }

    protected function redirectTo()
    {
        return route('user.auth.login');
    }

    public function showResetForm(Request $request, $token = null)
    {
        return view('user::auth.passwords.reset')->with([
            'token' => $token,
            'email' => $request->email,
            'account_type' => $request->account_type,
        ]);
    }

    protected function credentials(Request $request)
    {
        $request['account_type'] = $request['account_type'] ?? User::ACCOUNT_TYPE_INDIVIDUAL;
        return $request->only(
            'email',
            'password',
            'password_confirmation',
            'token',
            'account_type',
        );
    }

    protected function rules()
    {
        return [
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:8',
            'account_type' => ['nullable', Rule::in([User::ACCOUNT_TYPE_INDIVIDUAL, User::ACCOUNT_TYPE_ORGANIZATION, User::ACCOUNT_TYPE_ACCESS])],
        ];
    }

    // End of class
}
