<?php

namespace Modules\User\Http\Controllers\Auth;

use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Validation\Rule;
use Modules\Common\Entities\User;

use Auth;

class LoginController extends Controller
{
    /*
      |-------------------------------------------------------------------------
      | Login Controller
      |-------------------------------------------------------------------------
      |
      | This controller handles authenticating beauticians for the application
      | and redirecting them to its dashboard. The controller uses a trait
      | to conveniently provide its functionality to your applications.
      |
     */

    use AuthenticatesUsers;

    public function __construct()
    {
        $this->middleware('guest:user')->except('logout');
    }

    protected function guard()
    {
        return Auth::guard('user');
    }

    protected function showLoginForm()
    {
        return view('user::auth.login');
    }

    protected function validateLogin(Request $request)
    {
        $request->validate([
            $this->username() => ['required', 'string'],
            'password' => ['required', 'string'],
            'account_type' => ['nullable', Rule::in([User::ACCOUNT_TYPE_INDIVIDUAL, User::ACCOUNT_TYPE_ORGANIZATION])],
        ]);
    }

    protected function credentials(Request $request)
    {
        $request['account_type'] = $request['account_type'] ?? User::ACCOUNT_TYPE_INDIVIDUAL;
        return $request->only($this->username(), 'password', 'account_type');
    }

    protected function authenticated(Request $request, $user)
    {
        // Check if user is blocked
        if ($user->is_blocked) {
            Auth::logout();
            return redirect()->route('user.auth.showLoginForm')->with('blocked', true);
        }

        return redirect()->intended();
    }

    protected function loggedOut(Request $request)
    {
        return redirect()->route('user.auth.login');
    }

    // End of class
}
