<?php

namespace Modules\User\Http\Controllers\Auth;

use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Validation\Rule;
use Modules\Common\Entities\User;

class ForgotPasswordController extends Controller
{
    /*
      |-------------------------------------------------------------------------
      | Password Reset Controller
      |-------------------------------------------------------------------------
      |
      | This controller is responsible for handling password reset emails and
      | includes a trait which assists in sending these notifications from
      | your application to your users. Feel free to explore this trait.
      |
     */

    use SendsPasswordResetEmails;


    public function showLinkRequestForm()
    {
        return view('user::auth.passwords.email');
    }

    protected function validateEmail(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'account_type' => ['nullable', Rule::in([User::ACCOUNT_TYPE_INDIVIDUAL, User::ACCOUNT_TYPE_ORGANIZATION, User::ACCOUNT_TYPE_ACCESS])],
        ]);
    }

    protected function credentials(Request $request)
    {
        $request['account_type'] = $request['account_type'] ?? User::ACCOUNT_TYPE_INDIVIDUAL;
        return $request->only('email', 'account_type');
    }

    // End of class
}
