<?php

$languagesRegExp = implode('|', array_keys(config('app.languages')));
Route::pattern('locale', $languagesRegExp);

Route::group(['middleware' => 'locale', 'prefix' => '/{locale}'], function () {
    Route::prefix('reports')->group(function () {
        Route::get('/', 'ReportsController@index')->name('reports.index');
        Route::get('/{id}', 'ReportsController@show')->name('reports.show');

        Route::group(['middleware' => ['auth:user', 'email_verified']], function () {
            Route::get('/{report}/report_abuse', 'Report\AbuseController@create')->name('reports.abuses.create');
            Route::post('/{report}/report_abuse', 'Report\AbuseController@store')->name('reports.abuses.store');
        });
    });
});
