@extends('blog::_layouts.master')

@section('title', __('messages.global.report_detail'))


@section('meta')
  {{-- Open Graph Meta --}}
  <meta property="og:title" content="{{ $report->typeFormatted }}" />
  <meta property="og:url" content="{{ route('reports.show', [$report]) }}" />
  <meta property="og:image" content="{{ $report->getFirstMediaUrl() }}" />
  <meta property="og:description" content="{{ $report->createdAtDateTimeFormatted }}" />
  <meta property="og:site_name" content="{{ config('app.name') }}" />
  <meta property="og:type" content="article" />
@endsection


@section('content')

  {{-- Header --}}
  <header class="pt-24">
    <div class="mx-auto container px-3 py-16">
      <div class="w-full text-center">
        <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.report_detail') }}</h1>
        <div class="mt-4 mb-2">
          <span
            class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold {{ $report->type == \Modules\Common\Entities\Report::TYPE_FOUND ? 'text-green-700' : 'text-red-700' }} mr-2 mb-2">{{ $report->typeFormatted }}</span>
          <span
            class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold text-gray-700 mr-2 mb-2">{{ $report->animalSpeciesFormatted }}</span>
          <span
            class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold text-gray-700 mr-2 mb-2">{{ $report->animalConditionFormatted }}</span>
          @if ($report->hasExpired())
            <span
              class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold text-red-700 mr-2 mb-2">Expiré</span>
          @endif
        </div>
        <p class="text-white text-base">
          <i class="fa fa-calendar"></i> {{ $report->createdAtDateFormatted }}
          &nbsp;&nbsp;&nbsp;&nbsp;
          <i class="fa fa-clock"></i> {{ $report->createdAtTimeFormatted }}
        </p>
      </div>
    </div>
  </header>


  {{-- Starting gradient --}}
  @include('landing::_layouts/_partials/gradient-start', ['fill' => '#ffffff'])


  {{-- Report --}}
  <section class="bg-white py-32 text-gray-800 border-b">

    {{-- Flash Message --}}
    <div class="container mx-auto">
      <div class="mx-auto w-full lg:w-1/2">
        @include('landing::_layouts/_partials/flash_messages')
      </div>
    </div>


    {{-- Top actions --}}
    <div class="mx-auto container mb-6">
      <div class="w-full flex flex-col lg:flex-row gap-6 items-center">
        {{-- Share buttons --}}
        <div class="w-full">
          <ul class="flex items-center justify-center lg:justify-start">
            <li class="mr-3">
              <span class="text-sm font-bold">Partager le signalement :</span>
            </li>
            <li class="mr-3">
              <a href="{{ Share::currentPage()->facebook()->getRawLinks() }}"
                class="flex items-center bg-blue-600 max-w-max shadow-sm hover:shadow-lg rounded-full w-12 h-12">
                <i class="fab fa-facebook-f mx-auto text-white"></i>
              </a>
            </li>
            <li class="mr-3">
              <a href="{{ Share::currentPage($report->typeFormatted)->twitter()->getRawLinks() }}"
                class="flex items-center bg-blue-400 max-w-max shadow-sm hover:shadow-lg rounded-full w-12 h-12">
                <i class="fab fa-twitter mx-auto text-white"></i>
              </a>
            </li>
          </ul>
        </div>
        {{-- Report abuse --}}
        <div class="w-full text-center lg:text-right">
          <a class="text-sm font-bold hover:text-orange-500" href="{{ route('reports.abuses.create', $report) }}">
            <i class="far fa-flag"></i> Signaler un abus
          </a>
        </div>
      </div>
    </div>

    {{-- Detail --}}
    <div class="mx-auto container">
      <div class="flex flex-wrap-reverse">
        {{-- Left --}}
        <div class="w-full lg:w-3/5 overflow-hidden border rounded-lg text-left">
          <table class="w-full">
            <tbody class="divide-y">
              <tr>
                <th class="w-1/2 px-4 py-4">#</th>
                <td class="w-1/2 px-4 py-4">{{ $report->id }}</td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4">{{ __('messages.global.date') }}</th>
                <td class="w-1/2 px-4 py-4">{{ $report->createdAtDateTimeFormatted }}</td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4">{{ __('messages.global.expires_at') }}</th>
                <td class="w-1/2 px-4 py-4">
                  @if ($report->hasExpired())
                    <span class="text-red-700">Expiré</span>
                  @else
                    {{ $report->expiresAtDateTimeFormatted }}
                  @endif
                </td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4">{{ __('messages.global.type') }}</th>
                <td
                  class="w-1/2 px-4 py-4 {{ $report->type == \Modules\Common\Entities\Report::TYPE_FOUND ? 'text-green-700' : 'text-red-700' }}">
                  {{ $report->typeFormatted }}</td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4">{{ __('messages.global.animal_species') }}</th>
                <td class="w-1/2 px-4 py-4">{{ $report->animalSpeciesFormatted }}</td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4">{{ __('messages.global.animal_condition') }}</th>
                <td class="w-1/2 px-4 py-4">{{ $report->animalConditionFormatted }}</td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4">{{ __('messages.global.where_is_animal') }}</th>
                <td class="w-1/2 px-4 py-4">{{ $report->final_location }}</td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4">{{ __('messages.global.comment') }}</th>
                <td class="w-1/2 px-4 py-4">{{ $report->comment }}</td>
              </tr>
              <tr>
                <th class="w-1/2 px-4 py-4 align-top">{{ __('messages.global.author') }}</th>
                <td class="w-1/2 px-4 py-4">
                  {{ $author->displayName }}
                  @if ((auth('user')->check() &&
          auth('user')->user()->hasVerifiedEmail()) ||
      $report->isLost())
                    <ul class="list-reset">
                      @if ($author->hasEmail())
                        <li class="mt-2 inline-block mr-2 md:block md:mr-0">
                          <div class="flex">
                            <i class="w-4 fa fa-envelope text-orange-500 mt-1 mr-2"></i>
                            <div>
                              <a href="mailto:{{ $author->email }}" class="text-gray-800">{{ $author->email }}</a>
                            </div>
                        </li>
                      @endif
                      @if ($author->hasPhone() &&
      (auth('user')->check() &&
          auth('user')->user()->hasVerifiedEmail()))
                        <li class="mt-2 inline-block mr-2 md:block md:mr-0">
                          <div class="flex">
                            <i class="w-4 fa fa-phone text-orange-500 mt-1 mr-2"></i>
                            <div>
                              <a href="tel:{{ $author->phone }}" class="text-gray-800">{{ $author->phone }}</a>
                            </div>
                        </li>
                      @endif
                    </ul>
                  @else
                    <p class="text-orange-500"><a href="{{ route('user.auth.login') }}"
                        class="font-bold">Connectez-vous</a> à votre compte utilisateur pour avoir accès aux
                      informations de localisation.</p>
                  @endif
                </td>
              </tr>
            </tbody>
          </table>
        </div>
        {{-- Right --}}
        <div class="w-full lg:w-2/5 mx-auto mb-8 pl-0 lg:pl-8">
          <a href="{{ $report->firstImage }}" target="_blank">
            <img
              @click="if(reportImagesBlurred && {{ $report->isNotHealthy() ? 1 : 0 }}) { $dispatch('show-blur-modal'); return false;}"
              :class="{'blur':reportImagesBlurred && {{ $report->isNotHealthy() ? 1 : 0 }} }"
              class="w-full rounded-xl shadow object-cover mx-auto" src="{{ $report->firstImage }}"
              style="max-width: 500px; height: 500px;">
          </a>
          <div class="flex justify-center mt-4 mx-auto text-center">
            @foreach ($report->images as $image)
              @if (!$loop->first)
                <div class="w-1/3 p-2">
                  <a href="{{ $image }}" target="_blank">
                    <img
                      @click="if(reportImagesBlurred && {{ $report->isNotHealthy() ? 1 : 0 }}) { $dispatch('show-blur-modal'); return false;}"
                      :class="{'blur':reportImagesBlurred && {{ $report->isNotHealthy() ? 1 : 0 }} }"
                      class="w-full rounded-xl shadow object-cover mx-auto" src="{{ $image }}"
                      style="max-width: 150px; height: 150px;">
                  </a>
                </div>
              @endif
            @endforeach
          </div>
        </div>

      </div>
    </div>
  </section>


  {{-- Map --}}
  <section class="bg-white border-b text-gray-800 py-32">
    <div class="mx-auto container">

      {{-- Title --}}
      <div class="mx-auto flex flex-wrap">
        <div class=" mx-auto mb-16">
          <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">
            {{ __('messages.global.location') }}</h1>
          <div class="w-full mt-4">
            <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
          </div>
        </div>
      </div>

      @if ((auth('user')->check() &&
          auth('user')->user()->hasVerifiedEmail()) ||
      $report->isLost())
        <div class="flex flex-wrap-reverse gap-16 md:gap-0 -mx-4">
          {{-- Left --}}
          <div class="w-full md:w-1/2 px-4">
            <div id="map" class="w-full rounded-xl" style="height: 400px;"></div>
          </div>
          {{-- Right --}}
          <div class="w-full md:w-1/2 px-4overflow-hidden border rounded-lg flex-grow text-left">
            <table class="w-full">
              <tbody class="divide-y">
                <tr>
                  <th class="w-1/2 px-4 py-4">{{ __('messages.global.address') }}</th>
                  <td class="w-1/2 px-4 py-4">{{ $report->location_address }}</td>
                </tr>
                <tr>
                  <th class="w-1/2 px-4 py-4">{{ __('messages.global.coordinates') }}</th>
                  <td class="w-1/2 px-4 py-4">{{ $report->location_latitude }}, {{ $report->location_longitude }}
                  </td>
                </tr>
                <tr>
                  <th class="w-1/2 px-4 py-4">{{ __('messages.global.actions') }}</th>
                  <td class="w-1/2 px-4 py-4">
                    <a href="https://www.google.com/maps/dir/?api=1&destination={{ $report->location_latitude }},{{ $report->location_longitude }}"
                      target="_blank"
                      class="rounded-full h-8 w-8 inline-flex items-center justify-center shadow gradient ml-2">
                      <i class="fa fa-location-arrow text-white"></i>
                    </a>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      @else
        <div class="mx-auto container">
          <div class="mx-auto text-center text-black text-xl w-full lg:w-1/2">
            <div class="bg-orange-100 border-t-4 border-orange-500 rounded-xl text-orange-700 px-4 py-3 shadow"
              role="alert">
              <div class="flex">
                <div>
                  <p><a href="{{ route('user.auth.login') }}" class="font-bold">Connectez-vous</a> à votre compte
                    utilisateur pour avoir accès aux informations de localisation.</p>
                  <p class="text-sm">&nbsp;</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      @endif
  </section>


  {{-- Latest Reports --}}
  @include('landing::home/_includes/latest_reports')


  {{-- Ending gradient --}}
  @include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection


@section('js')
  <script>
    function initMap() {
      var position = {
        lat: {{ $report->location_latitude }},
        lng: {{ $report->location_longitude }}
      };
      var map = new google.maps.Map(
        document.getElementById('map'), {
          zoom: 16,
          center: position
        });
      var marker = new google.maps.Marker({
        position: position,
        map: map
      });
    }
  </script>
  <script defer
    src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.api_key') }}&callback=initMap">
  </script>
@endsection
