@extends('blog::_layouts.master')

@section('title', __('messages.global.report_abuse'))

@section('content')


  {{-- Header --}}
  <header class="pt-24">
    <div class="mx-auto container px-3 py-16">
      <div class="w-full text-center">
        <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.report_abuse') }}</h1>
      </div>
    </div>
  </header>


  {{-- Starting gradient --}}
  @include('landing::_layouts/_partials/gradient-start', ['fill' => '#f7fafc'])


  {{-- Content --}}
  <section class="bg-gray-100 py-32">
    <div class="container mx-auto">

      <div class="mx-auto text-black text-xl w-full lg:w-1/2 ">

        {{-- Report --}}
        <div class="mb-6">
          @include('reports::_partials/report', ['report' => $report])
        </div>

        {{-- Form --}}
        <form method="post" action="{{ route('reports.abuses.store', $report) }}"
          class="mx-auto bg-white shadow rounded-xl px-6 py-6">
          {{-- CSRF --}}
          @csrf

          {{-- Type Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="type">
              {{ __('messages.global.abuse_type') }}
            </label>
            <select name="type" placeholder="{{ __('messages.global.abuse_type') }}"
              class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
              <option value="">-</option>
              <option value="{{ Modules\Common\Entities\Abuse::TYPE_INAPPROPRIATE_CONTENT }}"
                {{ old('type') == Modules\Common\Entities\Abuse::TYPE_INAPPROPRIATE_CONTENT ? 'selected' : '' }}>
                {{ __('messages.abuse_type.inappropriate_content') }}</option>
              <option value="{{ Modules\Common\Entities\Abuse::TYPE_OTHER }}"
                {{ old('type') == Modules\Common\Entities\Abuse::TYPE_OTHER ? 'selected' : '' }}>
                {{ __('messages.abuse_type.other') }}</option>
            </select>
            @if ($errors->has('type'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('type') }}</p>
            @endif
          </div>


          {{-- Comment Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="comment">
              {{ __('messages.global.comment') }}
            </label>
            <textarea id="comment" name="comment"
              placeholder="{{ __('messages.global.write_your_comment_here') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">{{ old('comment') }}</textarea>
            <div id="the-count" class="text-right text-sm text-gray-700">
              <span id="current">0</span>
              <span id="maximum">/ 1000</span>
            </div>
            @if ($errors->has('comment'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('comment') }}</p>
            @endif
          </div>

          {{-- Submit Button --}}
          <div class="text-center lg:text-left">
            <button type="submit"
              class="gradient text-white font-bold rounded-full mt-4 lg:mt-0 py-4 px-8 opacity-75 hover:opacity-100 shadow">
              {{ __('messages.global.submit') }}
            </button>
          </div>
        </form>

      </div>
    </div>
  </section>


  {{-- Ending gradient --}}
  @include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection


@section('js')
  {{-- Counter for comment textarea --}}
  <script>
    $(function() {
      countCharacters();
    });

    $('textarea#comment').keyup(function() {
      countCharacters();
    });

    function countCharacters() {
      var characterCount = $('textarea#comment').val().length,
        current = $('#current'),
        maximum = $('#maximum'),
        theCount = $('#the-count');

      if (characterCount > 1000) {
        $(this).val($(this).val().substring(0, 1000));
        characterCount = $(this).val().length;
        theCount.removeClass('text-muted');
        theCount.addClass('text-danger');
        theCount.addClass('text-bold');
      } else {
        theCount.addClass('text-muted');
        theCount.removeClass('text-danger');
        theCount.removeClass('text-bold');
      }

      current.text(characterCount);
    }
  </script>
@endsection
