<?php

namespace Modules\Reports\Http\Controllers\Report;

use Illuminate\Routing\Controller;

use Modules\Common\Http\Requests\AbuseStoreRequest;
use Modules\Common\Entities\Abuse;
use Modules\Common\Entities\Report;

class AbuseController extends Controller
{

    /***************************************************************************
     * Methods
     **************************************************************************/
    public function create(Report $report)
    {
        // Get values
        $abuseTypes = Abuse::TYPES;

        // Return View
        return view('reports::abuse.create', compact(
            'report', 'abuseTypes',
        ));
    }

    public function store(AbuseStoreRequest $request, Report $report)
    {
        // Validate data
        $validated = $request->validated();
        $validated['user_id'] = auth()->id();

        // Create Abuse
        $abuse = $report->abuses()->create($validated);

        // Redirect
        return redirect()
                ->route('reports.show', $report)
                ->with('success', __('messages.create_abuse.success'));
    }

    // End of class
}
