<?php

$languagesRegExp = implode('|', array_keys(config('app.languages')));
Route::pattern('locale', $languagesRegExp);

// Root
Route::get('/', function () {
    return redirect()->route('landing.home.index', [
        'locale' => session('locale', config('app.locale')),
    ]);
});

// Localized routes
Route::group(['middleware' => 'locale', 'prefix' => '/{locale}'], function () {
    Route::get('/', 'HomeController@index')->name('landing.home.index');
    Route::get('/donate', 'DonateController@index')->name('landing.donate.index');
    Route::view('/terms-of-service', 'landing::terms.index')->name('landing.terms.index');

    Route::get('/links/terms-of-service', 'LinkController@termsOfService');
    Route::get('/links/lost-animal', 'LinkController@lostAnimal');
    Route::get('/links/mistreated-animal', 'LinkController@mistreatedAnimal');
});
