<section id="section-contact" class="section-contact">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <h2 class="text-center">{{ __('messages.global.contact_us') }}</h2>
      </div>
    </div>

    <div class="row">
      <div class="col-lg-6">
        <div class="text-area">
          <h4>{{ config('app.name') }}</h4>
          <p>{!! __('messages.about.content') !!}</p>
          <ul class="contact-list list-unstyled list-inline">
            <li class="list-inline-item"><i class="fas fa-map-marker-alt" aria-hidden="true"></i>Rue Eudore
              Davio 33, 4102 Seraing, Belgique</li>
            <li class="list-inline-item"><i class="fas fa-phone" aria-hidden="true"></i><a
                  class="phone-number" href="tel:+32497114045">+32 497 11 40 45</a></li>
            <li class="list-inline-item"><i class="far fa-envelope" aria-hidden="true"></i><a
                  class="underline-light"
                  href="mailto:infos@animal-research.be">infos@animal-research.be</a></li>
            <li class="list-inline-item"><i class="fab fa-chrome" aria-hidden="true"></i><a
                  class="underline-light" href="https://www.animal-research.be">www.animal-research.be</a>
            </li>
          </ul>
          <h4>{{ __('messages.global.social_media') }}</h4>
          <a target="_blank" href="https://www.facebook.com/AnimalResearchAPP">
            <span class="fa-layers fa-fw">
              <i class="fas fa-circle facebook"></i>
              <i class="fa-inverse fab fa-facebook-f fa-1x" data-fa-transform="shrink-6"></i>
            </span>
          </a>
          <a target="_blank" href="https://www.instagram.com/animal_research_">
            <span class="fa-layers fa-fw">
              <i class="fas fa-circle instagram"></i>
              <i class="fa-inverse fab fa-instagram fa-1x" data-fa-transform="shrink-6"></i>
            </span>
          </a>
        </div>
      </div>

      {{-- Contact Form --}}
      <div class="col-lg-6">
        <form id="contact-form" method="post" action="{{ route('contact.send') }}" data-toggle="validator">
          @csrf
          <div class="form-group">
            <input type="text" class="form-control-input" id="contact-form-name" name="name"
                   placeholder="{{ __('messages.global.name') }}" value="{{ old('name') }}" required>
            @if ($errors->has('name'))
            <span class="small text-danger">{{ $errors->first('name') }}</span>
            @endif
            <div class="help-block with-errors"></div>
          </div>
          <div class="form-group">
            <input type="email" class="form-control-input" id="contact-form-email" name="email"
                   placeholder="{{ __('messages.global.email_address') }}"
                   value="{{ old('email_address') }}" required>
            @if ($errors->has('email'))
            <span class="small text-danger">{{ $errors->first('email') }}</span>
            @endif
            <div class="help-block with-errors"></div>
          </div>
          <div class="form-group">
            <input type="text" class="form-control-input" id="contact-form-subject" name="subject"
                   placeholder="{{ __('messages.global.subject') }}" value="{{ old('subject') }}"
                   required>
            @if ($errors->has('subject'))
            <span class="small text-danger">{{ $errors->first('subject') }}</span>
            @endif
            <div class="help-block with-errors"></div>
          </div>
          <div class="form-group textarea">
            <textarea class="form-control-textarea" id="contact-form-content" name="content"
                      placeholder="{{ __('messages.global.write_your_message_here') }}"
                      required>{{ old('content') }}</textarea>
            @if ($errors->has('content'))
            <span class="small text-danger">{{ $errors->first('content') }}</span>
            @endif
            <div class="help-block with-errors"></div>
          </div>
          <div class="form-group">
            <button type="submit"
                    class="form-control-submit-button">{{ __('messages.global.submit') }}</button>
          </div>
          <div class="form-message">
            <div id="msgCSubmit" class="h3 text-center hidden"></div>
          </div>
        </form>
      </div>

    </div>
  </div>
</section>
