<footer class="bg-white">
  <div class="container mx-auto px-8">

    <div class="w-full flex flex-col md:flex-row gap-4 py-6">

      <div class="flex-1 mb-6">
        <a class="text-gray-700 no-underline hover:no-underline font-bold text-2xl"
          href="{{ route('landing.home.index') }}">
          {{ config('app.name') }} ASBL
        </a>
        <ul class="list-reset mb-6">
          <li class="mt-2 mr-2 md:mr-0">
            <div class="flex">
              <i class="w-4 fa fa-map-marker-alt text-orange-500 mt-1 mr-2"></i>
              <div>
                <span class="text-gray-800">Rue Eudore Davio 33<br>4102 Seraing<br>Belgique</span>
              </div>
          </li>
          <li class="mt-2 mr-2 md:mr-0">
            <div class="flex">
              <i class="w-4 fa fa-phone text-orange-500 mt-1 mr-2"></i>
              <div>
                <span class="text-gray-800">+32 497 11 40 45</span>
              </div>
          </li>
          <li class="mt-2 mr-2 md:mr-0">
            <div class="flex">
              <i class="w-4 fa fa-envelope text-orange-500 mt-1 mr-2"></i>
              <div>
                <span class="text-gray-800">infos@animal-research.be</span>
              </div>
          </li>
          <li class="mt-2 mr-2 md:mr-0">
            <div class="flex">
              <div>
                <span class="text-center text-gray-600 font-bold text-sm">N° Association BE0744.541.019</span>
              </div>
          </li>
        </ul>
      </div>

      <div class="flex-1">
        <p class="uppercase text-gray-500 md:mb-6">{{ __('messages.global.menu') }}</p>
        <ul class="list-reset mb-6">
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('landing.home.index') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.home') }}</a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('blog.index') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.blog') }}</a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('reports.index', ['radius' => 10]) }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">
              {{ __('messages.global.lost_and_found_animals') }}
            </a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('user.reports.create') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.report_his_lost_animal') }}</a>
          </li>
          @if (!$browserIsSafari)
            <li class="mt-2 inline-block mr-2 md:block md:mr-0">
              <a href="{{ route('landing.donate.index') }}"
                class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.donate') }}</a>
            </li>
          @endif
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('contact.index') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.contact_us') }}</a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('landing.terms.index') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.terms_of_service') }}</a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ url('landing/files/politique-de-confidentialite.pdf') }}" target="_blank"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.privacy_policy') }}</a>
          </li>
        </ul>
      </div>
      <div class="flex-1">
        <p class="uppercase text-gray-500 md:mb-6">{{ __('messages.global.user_area') }}</p>
        <ul class="list-reset mb-6">
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('user.auth.login') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.login') }}</a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('user.auth.register') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.register') }}</a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a href="{{ route('password.request') }}"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">{{ __('messages.global.forgot_password') }}</a>
          </li>
        </ul>
      </div>
      <div class="flex-1">
        <p class="uppercase text-gray-500 md:mb-6">{{ __('messages.global.social_media') }}</p>
        <ul class="list-reset mb-6">
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a target="_blank" href="https://www.facebook.com/AnimalResearchAPP"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">Facebook</a>
          </li>
          <li class="mt-2 inline-block mr-2 md:block md:mr-0">
            <a target="_blank" href="https://www.instagram.com/animal_research_app"
              class="no-underline hover:underline text-gray-800 hover:text-orange-500">Instagram</a>
          </li>
        </ul>
      </div>

    </div>
  </div>

  <p class="border-t text-center text-gray-500 py-4">
    <span>© <strong>{{ config('app.name') }} ASBL</strong></span>
    -
    <span>{{ __('messages.global.developed_by') }} <a target="_blank" href="https://www.kapps.be"
        class="text-orange-500">kapps.be</a></span>
  </p>

</footer>
