<?php

namespace Modules\Landing\Http\Controllers;

use Illuminate\Routing\Controller;

use Modules\Blog\Entities\Post;
use Modules\Common\Entities\Report;

class HomeController extends Controller
{

    public function index()
    {
        // Get latest posts
        $latestPosts = Post::published()->take(4)->latest()->get();

        // Get latest reports
        $latestReports = Report::available()->take(4)->latest('expires_at')->get();

        return view('landing::home.index', compact('latestPosts', 'latestReports'));
    }

    // End of class
}
