@extends('blog::_layouts.master')

@section('title', __('messages.global.contact_us'))

@section('css')
  {{-- reCAPTCHA --}}
  {!! htmlScriptTagJsApi() !!}
@endsection

@section('content')


  {{-- Header --}}
  <header class="pt-24">
    <div class="mx-auto container px-3 py-16">
      <div class="w-full text-center">
        <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.contact_us') }}</h1>
      </div>
    </div>
  </header>


  {{-- Starting gradient --}}
  @include('landing::_layouts/_partials/gradient-start', ['fill' => '#ffffff'])


  {{-- Flash Messages --}}
  <section class="bg-white">
    @include('landing::_layouts/_partials/flash_messages')
    @if (Session::has('errors'))
      <div class="max-w-md mx-auto px-3 py-16">
        <div class="bg-red-100 border-t-4 border-red-500 rounded-xl text-red-900 px-4 py-3 mb-4 shadow" role="alert">
          <div class="flex">
            <div class="mx-auto">
              <p class="font-bold">Le formulaire de contact contient des erreurs</p>
              <p class="text-sm">&nbsp;</p>
            </div>
          </div>
        </div>
      </div>
    @endif
  </section>


  {{-- Contact Info --}}
  <section class="bg-white py-8">
    <div class="container mx-auto px-2 pt-4 pb-12 text-gray-700">

      {{-- Section content --}}
      <div class="grid grid-cols-1 md:grid-cols-3 mt-12">
        {{-- 1 --}}
        <div class="mx-auto py-12 text-center">
          <i class="fa fa-map-marker-alt text-6xl text-orange-500 mb-12"></i>
          <div class="ml-4">
            <h3 class="text-3xl font-bold leading-none mb-6">
              Coordonnées
            </h3>
            <div class="mt-2 text-base text-gray-500">
              <p class="py-2">
                <span class="text-primary font-bold">Animal Research ASBL</span><br>
                Rue Eudore Davio 33<br>
                4102 Seraing<br>
                Belgique
              </p>
              <p class="py-2">
                <span class="text-primary font-bold">N° Association BE0744.541.019</span><br>
              </p>
            </div>
          </div>
        </div>

        {{-- 2 --}}
        <div class="mx-auto py-12 text-center">
          <i class="fa fa-phone text-6xl text-orange-500 mb-12"></i>
          <div class="ml-4">
            <h3 class="text-3xl font-bold leading-none mb-6">
              Numéro de téléphone
            </h3>
            <div class="mt-2 text-base text-gray-500">
              <p class="py-2"><span class="text-primary font-bold">Support</span><br>+32 497 11 40 45<br><span
                  class="text-sm">Du lundi au vendredi de 9h00 à 17h00</span></p>
            </div>
          </div>
        </div>

        {{-- 3 --}}
        <div class="mx-auto py-12 text-center">
          <i class="fa fa-envelope text-6xl text-orange-500 mb-12"></i>
          <div class="ml-4">
            <h3 class="text-3xl font-bold leading-none mb-6">
              Adresse e-mail
            </h3>
            <div class="mt-2 text-base text-gray-500">
              <p class="py-2"><span class="text-primary font-bold">Général</span><br>infos@animal-research.be
              </p>
              <p class="py-2"><span class="text-primary font-bold">Support</span><br>support@animal-research.be
              </p>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>


  {{-- Contact Form --}}
  <section class="bg-gray-100 py-32">
    <div class="container mx-auto text-gray-700">

      {{-- Section title --}}
      <h1 class="w-full my-2 text-5xl font-thin leading-tight text-center">
        Formulaire de contact
      </h1>
      <div class="w-full mb-12">
        <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
      </div>

      <div class="mx-auto text-left text-black text-xl w-full lg:w-1/2 ">

        {{-- Form --}}
        <form method="post" action="{{ route('contact.send') }}" class="mx-auto bg-white shadow rounded-xl px-6 py-6">
          {{-- CSRF --}}
          @csrf

          {{-- Name Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="name">
              {{ __('messages.global.name') }}
            </label>
            <input type="text" name="name" value="{{ old('name') }}"
              placeholder="{{ __('messages.global.name') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('name'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('name') }}</p>
            @endif
          </div>

          {{-- Email Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="email">
              {{ __('messages.global.email_address') }}
            </label>
            <input type="text" name="email" value="{{ old('email') }}"
              placeholder="{{ __('messages.global.email_address') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('email'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('email') }}</p>
            @endif
          </div>

          {{-- Subject Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="subject">
              {{ __('messages.global.subject') }}
            </label>
            <input type="text" name="subject" value="{{ old('subject') }}"
              placeholder="{{ __('messages.global.subject') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('subject'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('subject') }}</p>
            @endif
          </div>

          {{-- Content Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="content">
              {{ __('messages.global.message') }}
            </label>
            <textarea type="text" name="content"
              placeholder="{{ __('messages.global.write_your_message_here') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">{{ old('content') }}</textarea>
            @if ($errors->has('content'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('content') }}</p>
            @endif
          </div>

          {{-- reCAPTCHA Field --}}
          <div class="mb-6">
            {!! htmlFormSnippet() !!}
            @if ($errors->has('g-recaptcha-response'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('g-recaptcha-response') }}</p>
            @endif
          </div>

          {{-- Submit Button --}}
          <div class="text-center lg:text-left">
            <button type="submit"
              class="gradient text-white font-bold rounded-full mt-4 lg:mt-0 py-4 px-8 opacity-75 hover:opacity-100 shadow">
              {{ __('messages.global.submit') }}
            </button>
          </div>
        </form>

      </div>
    </div>
  </section>


  {{-- Ending gradient --}}
  @include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection
