<?php

namespace Modules\Contact\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

use Modules\Contact\Entities\ContactEmail;

class ContactEmailStored extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    private $contactEmail;
    
    public function __construct(ContactEmail $contactEmail)
    {
        $this->contactEmail = $contactEmail;
    }

    public function build()
    {
        return $this->from(config('mail.from.address'), $this->contactEmail->name)
                    ->replyTo($this->contactEmail->email, $this->contactEmail->name)
                    ->subject($this->contactEmail->subject)
                    ->view('contact::contact_emails.emails.stored')
                    ->with(['contactEmail' => $this->contactEmail]);
    }
    
    // End of class
}
