<?php

namespace Modules\Contact\Http\Services;

use Illuminate\Foundation\Http\FormRequest;

use Modules\Contact\Entities\ContactEmail;

class ContactEmailService extends FormRequest
{

    public function store(array $attributes)
    {
        // Get client IP
        $clientIp= \Request::ip();
        
        // Add IP to attributes
        $attributes['ip_address'] = $clientIp;

        // Store ContactEmail
        $contactEmail = ContactEmail::create($attributes);

        // Return ContactEmail
        return $contactEmail;
    }
    
    // End of class
}