<?php

namespace Modules\Contact\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreContactEmailRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:60',
            'email' => 'required|email:rfc,dns|max:120',
            'subject' => 'required|string|max:120',
            'content' => 'required|max:2000',
            'g-recaptcha-response' => 'recaptcha',
        ];
    }

    // End of class
}
