<?php

namespace Modules\Contact\Http\Controllers;

use Illuminate\Routing\Controller;

use Modules\Contact\Http\Requests\StoreContactEmailRequest;
use Modules\Contact\Http\Services\ContactEmailService;
use Modules\Contact\Mail\ContactEmailStored;

use Mail;

class ContactController extends Controller
{

    public function index()
    {
        return view('contact::index');
    }

    public function send(StoreContactEmailRequest $request)
    {
        // Create ContactEmail
        $contactEmail = (new ContactEmailService())->store($request->validated());

        // Send email
        Mail::to(env('CONTACT_EMAIL_ADDRESS'))->send(new ContactEmailStored($contactEmail));

        // Redirect
        return redirect()->back()->with('success', __('messages.contact.success'));
    }

    // End of class
}
