<?php

namespace Modules\Common\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Http\UploadedFile;


class FileOrUrl implements Rule
{

    const MAX_SIZE = 15 * 1024 * 1024;
    const MIME_TYPES = ['image/jpg', 'image/jpeg'];

    private $errorMsg = '';

    public function passes($attribute, $value)
    {
        // If URL
        if (is_string($value)) {
            return true;
        }

        // If File
        if ($value instanceof UploadedFile) {
            // Check max size
            if ($value->getSize() > self::MAX_SIZE) {
                $this->errorMsg = __('validation.max.file', ['max' => self::MAX_SIZE / 1024]);
                return false;
            }

            // Check allowed mime types
            if (!in_array($value->getMimeType(), self::MIME_TYPES)) {
                $this->errorMsg = __('validation.mimetypes');
                return false;
            }

            // Passes
            return true;
        }

        // Not passes
        $this->errorMsg = __('validation.file_or_url');
        return false;
    }

    public function message()
    {
        return $this->errorMsg;
    }

    // End of class
}
