<?php

namespace Modules\Common\Observers;

use Spatie\Geocoder\Geocoder;
use Modules\Common\Entities\User;


class UserObserver
{

    /***************************************************************************
     * Events
     **************************************************************************/
    public function created(User $user)
    {
        // Update address if needed
        if (!$user->hasAddress()) {
            $this->updateAddress($user);
        }
    }

    public function updated(User $user)
    {
        // Update address if needed
        if (!$user->hasAddress()) {
            $this->updateAddress($user);
        }
    }

    /***************************************************************************
     * Utils
     **************************************************************************/
    private function updateAddress(User $user)
    {
        try {
            // Init. Geocoder
            $geocoder = $this->createGeocoder();

            // Prepare variables
            $lat = $user->location_latitude;
            $lng = $user->location_longitude;

            // Get location
            $location = $geocoder->getAddressForCoordinates($lat, $lng);

            // Update address from location
            if (!$user->address) {
                $user->address = $location['formatted_address'];
            }

            // Exctract components
            foreach ($location['address_components'] as $component) {
                if ($component->types[0] == 'postal_code') {
                    $user->location_zipcode = $component->short_name;
                }
                if ($component->types[0] == 'country') {
                    $user->location_country = $component->short_name;
                }
            }

            // Save user
            $user->save();
        } catch (\Throwable $e) {
            // Handle error
        }
    }

    private function createGeocoder()
    {
        // Init. Geocoder
        $client = new \GuzzleHttp\Client();
        $geocoder = new Geocoder($client);

        // Set Geocoder
        $geocoder->setApiKey(config('geocoder.key'));
        $geocoder->setLanguage(config('geocoder.language'));

        // Return Geocoder
        return $geocoder;
    }

    // End of class
}
