<?php

namespace Modules\Common\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

use Modules\Common\Entities\Abuse;


class NotifyUserOfSuspendedReport extends Notification
{
    use Queueable;

    protected $abuse;
    
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Abuse $abuse)
    {
        $this->abuse = $abuse;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject(__('Your report has been suspended'))
                    ->line(__('Your report has been suspended.'))
                    ->line(__('An administrator will verify your report. If it complies with the terms of use, it will be reposted. Otherwise, your report will be deleted.'))
                    ->line(__('For more information please contact support at +32 497 11 40 45 Monday to Friday 9:00 a.m. to 5:00 p.m. or by e-mail at support@animal-research.be'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
    
    // End of class
}
