<?php

namespace Modules\Common\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

use Benwilkins\FCM\FcmMessage;

use Modules\Common\Entities\Report;
use Modules\Api\Http\Resources\Report as ReportResource;


class NotifyUserIfLostAnimalExists extends Notification
{
    use Queueable;

    protected $report;

    public function __construct(Report $report)
    {
        $this->report = $report;
    }

    public function via($notifiable)
    {
        // Notifiy only if premium or organization_access
        if ($notifiable->isPremium || $notifiable->isOrganizationAccess) {
            return ['mail', 'fcm'];
        } else {
            return [];
        }
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject(__('A lost animal matches your report'))
            ->line(__('A lost animal matches your report.'))
            ->action(__('Show report'), $this->report->getLinkAttribute());
    }

    public function toFcm($notifiable)
    {
        $report = $this->report;

        $fcmMessage = new FcmMessage();
        $fcmMessage->content([
            'title'        => __('messages.global.animal_lost'),
            'body'         =>  __('A lost animal matches your report'),
            'image'        => $report->isHealthy() ? $report->thumbnail : null,
            'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
        ])->data([
            'type' => 'report',
            'data' => new ReportResource($report),
        ])->priority(FcmMessage::PRIORITY_HIGH);

        return $fcmMessage;
    }

    // End of class
}
