<?php

namespace Modules\Common\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Animal;

class ReportUpdateRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'animal_species'        => [Rule::in(Animal::ANIMAL_SPECIES)],
            'animal_condition'      => [Rule::in(Animal::ANIMAL_CONDITIONS)],
            'identification_type'   => ['nullable', Rule::in(array_merge(Animal::IDENTIFICATION_TYPES, ['']))],
            'identification_number' => ['nullable', 'string', 'max:20'],
            'final_location'        => ['nullable', 'string', 'max:180'],
            'comment'               => ['nullable', 'string', 'max:1000'],
        ];
    }

    // End of class
}
