<?php

namespace Modules\Common\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Animal;
use Modules\Common\Rules\FileOrUrl;


class ReportStoreRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'location_address'      => ['nullable', 'string', 'max:180'],
            'location_latitude'     => ['required', 'numeric', 'min:-90',  'max:90'],
            'location_longitude'    => ['required', 'numeric', 'min:-180', 'max:180'],
            'location_zipcode'      => ['nullable', 'string', 'max:20'],
            'location_country'      => ['nullable', 'string', 'max:30'],
            'animal_species'        => ['required', Rule::in(Animal::ANIMAL_SPECIES)],
            'animal_condition'      => ['nullable', Rule::in(Animal::ANIMAL_CONDITIONS)],
            'identification_type'   => ['nullable', Rule::in(array_merge(Animal::IDENTIFICATION_TYPES, ['']))],
            'identification_number' => ['nullable', 'string', 'max:20'],
            'final_location'        => ['nullable', 'string', 'max:180'],
            'comment'               => ['nullable', 'string', 'max:1000'],
            'images'                => ['required', 'array', 'min:1', 'max:3'],
            'images.*'              => ['required', new FileOrUrl()],
        ];
    }

    public function attributes()
    {
        return [
            "images.0" => "image",
        ];
    }

    public function messages()
    {
        return [
            'images.0.max' => "L'image dépasse la taille maximale autorisée"
        ];
    }

    // End of class
}
