<?php

namespace Modules\Common\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Animal;
use Modules\Common\Rules\FileOrUrl;

class RegisteredAnimalUpdateRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name'                  => ['required', 'string', 'max:30'],
            'animal_species'        => [Rule::in(Animal::ANIMAL_SPECIES)],
            'identification_type'   => ['nullable', Rule::in(array_merge(Animal::IDENTIFICATION_TYPES, ['']))],
            'identification_number' => ['nullable', 'string', 'max:20'],
            'comment'               => ['nullable', 'string', 'max:1000'],
            'images'                => ['required', 'array', 'min:1', 'max:3'],
            'images.*'              => ['required', new FileOrUrl()],
        ];
    }

    // End of class
}
