<?php

namespace Modules\Common\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Animal;

class AlertStoreRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'animal_species'     => ['required', Rule::in(array_merge(Animal::ANIMAL_SPECIES_CATEGORIES, Animal::ANIMAL_SPECIES))],
            'location_address'   => ['required', 'string', 'max:180'],
            'location_latitude'  => ['required', 'numeric', 'min:-90',  'max:90'],
            'location_longitude' => ['required', 'numeric', 'min:-180', 'max:180'],
            'radius'             => ['required', 'numeric', 'min:1', 'max:100'],
        ];
    }

    // End of class
}
