<?php

namespace Modules\Common\Entities\Scopes;

use Modules\Common\Entities\Report;


trait AlertScopes
{

    public function scopeMatchesReport($query, Report $report)
    {
        // Prepare values
        $coordinates = [
            'latitude' => $report->location_latitude,
            'longitude' => $report->location_longitude,
        ];

        // Filter by radius
        $query = $query->inRadiusByField($coordinates);

        // Filter by animal species
        $query = $query->whereRaw("? LIKE CONCAT(`animal_species`, '%')", [$report->animal_species]);

        // Return query
        return $query;
    }

    // End of class
}
