<?php

namespace Modules\Common\Entities\Relationships;

use Modules\Common\Entities\Abuse;
use Modules\Common\Entities\Alert;
use Modules\Common\Entities\NotificationToken;
use Modules\Common\Entities\PremiumCity;
use Modules\Common\Entities\RegisteredAnimal;
use Modules\Common\Entities\Report;
use Modules\Common\Entities\User;

trait UserRelationships
{

    public function notificationTokens()
    {
        return $this->hasMany(NotificationToken::class);
    }

    public function reports()
    {
        return $this->hasMany(Report::class);
    }

    public function reportsWithMembers()
    {
        if ($this->isOrganization) {
            $related = $this->hasMany(Report::class);
            $related->setQuery(
                Report::whereHas('user', function ($query) {
                    $query->where('extras->organization_id', $this->id);
                })->orWhere('user_id', $this->id)->getQuery()
            );
            return $related;
        } else {
            return $this->hasMany(Report::class);
        }
    }

    public function registeredAnimals()
    {
        return $this->hasMany(RegisteredAnimal::class);
    }

    public function alerts()
    {
        return $this->hasMany(Alert::class);
    }

    public function abuses()
    {
        return $this->hasMany(Abuse::class);
    }

    public function members()
    {
        $related = $this->hasMany(User::class);
        $related->setQuery(
            User::where('extras->organization_id', $this->id)->getQuery()
        );

        return $related;
    }

    public function organization()
    {
        $organizationId = $this->organizationId ?? $this->id;

        $related = $this->hasOne(User::class)->withDefault(User::DEFAULT_VALUES);
        $related->setQuery(
            User::where('id', $organizationId)->getQuery()
        );

        return $related;
    }

    public function premiumCities()
    {
        $related = $this->hasMany(PremiumCity::class, 'country', 'location_country');

        $related->setQuery(
            PremiumCity::whereRaw('FIND_IN_SET(`location_zipcode`, REPLACE(zipcodes, " ", "")) AND `country` = `location_country`')
                ->getQuery()
        );

        return $related;
    }

    // End of class
}
