<?php

namespace Modules\Common\Entities\Presenters;

trait ReportPresenter
{

    public function getCreatedAtDateFormattedAttribute()
    {
        return $this->created_at->format('d/m/Y');
    }

    public function getCreatedAtTimeFormattedAttribute()
    {
        return $this->created_at->format('H:i');
    }

    public function getCreatedAtDateTimeFormattedAttribute()
    {
        return $this->created_at->format('d/m/Y - H:i');
    }

    public function getExpiresAtDateTimeFormattedAttribute()
    {
        return $this->expires_at->format('d/m/Y - H:i');
    }

    public function getAnimalConditionFormattedAttribute()
    {
        return __('messages.animal_condition.' . $this->animal_condition);
    }

    public function getTypeFormattedAttribute()
    {
        return __('messages.report_type.' . $this->type);
    }

    public function getStateFormattedAttribute()
    {
        return __('messages.report_state.' . $this->state);
    }

    public function getCityFormattedAttribute()
    {
        if (!$this->location_address) {
            return 'Adresse inconnue';
        }
        $addressParts = explode(',', $this->location_address);
        if (count($addressParts) == 1) {
            return $addressParts[0];
        }
        return $addressParts[count($addressParts) - 2];
    }

    public function getDeletionReasonFormattedAttribute()
    {
        return __('messages.deletion_reason.' . $this->deletion_reason);
    }

    // End of class
}
