<?php

namespace Modules\Common\Entities;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Modules\Common\Entities\Traits\Localizable;

class Place extends Model
{
    use Localizable, CrudTrait;

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $fillable = [
        'name', 'type', 'phone', 'content', 'zipcodes', 'country',
        'location_address', 'location_latitude', 'location_longitude',
    ];

    /***************************************************************************
     * Scopes
     **************************************************************************/
    public function scopeInZipcodes($query, $zipcode)
    {
        return $query->whereRaw('FIND_IN_SET(?, REPLACE(zipcodes, " ", ""))', [
            $zipcode,
        ]);
    }

    /***************************************************************************
     * Type Values
     **************************************************************************/
    const TYPE_CREAVES = 'creaves';
    const TYPE_POLICE = 'police';
    const TYPE_ROAD = 'road';
    const TYPE_SHELTER = 'shelter';
    const TYPE_VETERINARY = 'veterinary';

    const TYPES = [
        self::TYPE_VETERINARY,
        self::TYPE_SHELTER,
        self::TYPE_ROAD,
        self::TYPE_POLICE,
        self::TYPE_CREAVES,
    ];

    // End of class
}
