<?php

namespace Modules\Common\Entities\Contracts;

interface MustVerifyPhone
{
    /**
     * Determine if the user has verified their phone.
     *
     * @return bool
     */
    public function hasVerifiedPhone();

    /**
     * Mark the given user's phone as verified.
     *
     * @return bool
     */
    public function markPhoneAsVerified($phone);

    /**
     * Send the phone verification code.
     *
     * @return void
     */
    public function sendPhoneVerificationCode();

    /**
     * Get the phone that should be used for verification.
     *
     * @return string
     */
    public function getPhoneForVerification();
}
