<?php

namespace Modules\Common\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\Common\Entities\Presenters\AnimalPresenter;


class Animal extends Model
{
    use AnimalPresenter;

    /***************************************************************************
     * Function
     **************************************************************************/
    public static function getAnimalSpeciesList()
    {
        return array_diff(Animal::ANIMAL_SPECIES, [
            Animal::ANIMAL_SPECIES_PET_DOG_SMALL,
            Animal::ANIMAL_SPECIES_PET_DOG_MEDIUM,
            Animal::ANIMAL_SPECIES_PET_DOG_LARGE,
            Animal::ANIMAL_SPECIES_PET_CAT,
        ]);
    }

    /***************************************************************************
     * AnimalCondition Values
     **************************************************************************/
    const ANIMAL_CONDITION_HEALTHY = 'healthy';
    const ANIMAL_CONDITION_HURT = 'hurt';
    const ANIMAL_CONDITION_DEAD = 'dead';

    const ANIMAL_CONDITIONS = [
        self::ANIMAL_CONDITION_HEALTHY,
        self::ANIMAL_CONDITION_HURT,
        self::ANIMAL_CONDITION_DEAD,
    ];

    /***************************************************************************
     * IdentificationType Values
     **************************************************************************/
    const IDENTIFICATION_TYPE_RING = 'ring';
    const IDENTIFICATION_TYPE_EARRING = 'earring';
    const IDENTIFICATION_TYPE_TATTOO = 'tattoo';
    const IDENTIFICATION_TYPE_MICROCHIP = 'microchip';

    const IDENTIFICATION_TYPES = [
        self::IDENTIFICATION_TYPE_RING,
        self::IDENTIFICATION_TYPE_EARRING,
        self::IDENTIFICATION_TYPE_TATTOO,
        self::IDENTIFICATION_TYPE_MICROCHIP,
    ];

    /***************************************************************************
     * AnimalSpeciesCategories Values
     **************************************************************************/
    const ANIMAL_SPECIES_CATEGORY_PET = 'pet';
    const ANIMAL_SPECIES_CATEGORY_PET_DOG = 'pet_dog';
    const ANIMAL_SPECIES_CATEGORY_PET_CAT = 'pet_cat';
    const ANIMAL_SPECIES_CATEGORY_LIVESTOCK = 'livestock';
    const ANIMAL_SPECIES_CATEGORY_CIRCUS = 'circus';
    const ANIMAL_SPECIES_CATEGORY_WILD = 'wild';
    const ANIMAL_SPECIES_CATEGORY_WILD_AQUATIC = 'wild_aquatic';

    const ANIMAL_SPECIES_CATEGORIES = [
        self::ANIMAL_SPECIES_CATEGORY_PET,
        self::ANIMAL_SPECIES_CATEGORY_PET_DOG,
        self::ANIMAL_SPECIES_CATEGORY_PET_CAT,
        self::ANIMAL_SPECIES_CATEGORY_LIVESTOCK,
        self::ANIMAL_SPECIES_CATEGORY_CIRCUS,
        self::ANIMAL_SPECIES_CATEGORY_WILD,
        self::ANIMAL_SPECIES_CATEGORY_WILD_AQUATIC,
    ];

    /***************************************************************************
     * AnimalSpecies Values
     **************************************************************************/
    const ANIMAL_SPECIES_PET_DOG_OTHER = 'pet_dog_other';
    const ANIMAL_SPECIES_PET_DOG_SHEPERD = 'pet_dog_shepherd';
    const ANIMAL_SPECIES_PET_DOG_BORDERCOLLIE = 'pet_dog_border-collie';
    const ANIMAL_SPECIES_PET_DOG_GOLDENRETRIEVER = 'pet_dog_golden-retriever';
    const ANIMAL_SPECIES_PET_DOG_MALINOIS = 'pet_dog_malinois';
    const ANIMAL_SPECIES_PET_DOG_LABRADOR = 'pet_dog_labrador';
    const ANIMAL_SPECIES_PET_DOG_BOUVIER = 'pet_dog_bouvier';
    const ANIMAL_SPECIES_PET_DOG_BULLDOG = 'pet_dog_bulldog';
    const ANIMAL_SPECIES_PET_DOG_ROTTWEILER = 'pet_dog_rottweiler';
    const ANIMAL_SPECIES_PET_DOG_JACKRUSSEL = 'pet_dog_jack-russell';
    const ANIMAL_SPECIES_PET_DOG_CHIHUAHUA = 'pet_dog_chihuahua';
    const ANIMAL_SPECIES_PET_DOG_YORKSHIRE = 'pet_dog_yorkshire';
    const ANIMAL_SPECIES_PET_DOG_BICHON = 'pet_dog_bichon';
    const ANIMAL_SPECIES_PET_DOG_SHIHTZU = 'pet_dog_shih-tzu';
    const ANIMAL_SPECIES_PET_DOG_STAFF = 'pet_dog_staff';
    const ANIMAL_SPECIES_PET_DOG_PUG = 'pet_dog_pug';
    const ANIMAL_SPECIES_PET_DOG_KINGCHARLES = 'pet_dog_king-charles';
    const ANIMAL_SPECIES_PET_DOG_COCKER = 'pet_dog_cocker';
    const ANIMAL_SPECIES_PET_DOG_BOXER = 'pet_dog_boxer';
    const ANIMAL_SPECIES_PET_DOG_HUSKY = 'pet_dog_husky';
    const ANIMAL_SPECIES_PET_DOG_DACHSHUND = 'pet_dog_dachshund';
    const ANIMAL_SPECIES_PET_DOG_DALMATIAN = 'pet_dog_dalmatian';
    const ANIMAL_SPECIES_PET_DOG_SMALL = 'pet_dog_small';
    const ANIMAL_SPECIES_PET_DOG_MEDIUM = 'pet_dog_medium';
    const ANIMAL_SPECIES_PET_DOG_LARGE = 'pet_dog_large';
    const ANIMAL_SPECIES_PET_CAT_OTHER = 'pet_cat_other';
    const ANIMAL_SPECIES_PET_CAT_EUROPEAN = 'pet_cat_european';
    const ANIMAL_SPECIES_PET_CAT_BENGAL = 'pet_cat_bengal';
    const ANIMAL_SPECIES_PET_CAT_PERSIAN = 'pet_cat_persian';
    const ANIMAL_SPECIES_PET_CAT_SIAMESE = 'pet_cat_siamese';
    const ANIMAL_SPECIES_PET_CAT_CHARTREUX = 'pet_cat_chartreux';
    const ANIMAL_SPECIES_PET_CAT_MAINECOON = 'pet_cat_maine-coon';
    const ANIMAL_SPECIES_PET_CAT_SPHYNX = 'pet_cat_sphynx';
    const ANIMAL_SPECIES_PET_CAT_SHORTHAIR = 'pet_cat_shorthair';
    const ANIMAL_SPECIES_PET_CAT_SIBERIAN = 'pet_cat_siberian';
    const ANIMAL_SPECIES_PET_CAT_NORWEGIAN = 'pet_cat_norwegian';
    const ANIMAL_SPECIES_PET_CAT = 'pet_cat';
    const ANIMAL_SPECIES_PET_RABBIT = 'pet_rabbit';
    const ANIMAL_SPECIES_PET_FERRET = 'pet_ferret';
    const ANIMAL_SPECIES_PET_RODENT = 'pet_rodent';
    const ANIMAL_SPECIES_PET_BIRD = 'pet_bird';
    const ANIMAL_SPECIES_PET_EQUINE = 'pet_equine';
    const ANIMAL_SPECIES_PET_FISH = 'pet_fish';
    const ANIMAL_SPECIES_PET_EXOTIC = 'pet_exotic';
    const ANIMAL_SPECIES_LIVESTOCK_FARMYARD = 'livestock_farmyard';
    const ANIMAL_SPECIES_LIVESTOCK_FARM = 'livestock_farm';
    const ANIMAL_SPECIES_CIRCUS_OTHER = 'circus_other';
    const ANIMAL_SPECIES_WILD_WOLF = 'wild_wolf';
    const ANIMAL_SPECIES_WILD_HEDGEHOG = 'wild_hedgehog';
    const ANIMAL_SPECIES_WILD_HART = 'wild_hart';
    const ANIMAL_SPECIES_WILD_HIND = 'wild_hind';
    const ANIMAL_SPECIES_WILD_FAWN = 'wild_fawn';
    const ANIMAL_SPECIES_WILD_BOAR = 'wild_boar';
    const ANIMAL_SPECIES_WILD_FOX = 'wild_fox';
    const ANIMAL_SPECIES_WILD_DUCK = 'wild_duck';
    const ANIMAL_SPECIES_WILD_BEAVER = 'wild_beaver';
    const ANIMAL_SPECIES_WILD_HARE = 'wild_hare';
    const ANIMAL_SPECIES_WILD_NUTRIA = 'wild_nutria';
    const ANIMAL_SPECIES_WILD_RODENT = 'wild_rodent';
    const ANIMAL_SPECIES_WILD_CAT = 'wild_cat';
    const ANIMAL_SPECIES_WILD_BEAR = 'wild_bear';
    const ANIMAL_SPECIES_WILD_LYNX = 'wild_lynx';
    const ANIMAL_SPECIES_WILD_ROE = 'wild_roe';
    const ANIMAL_SPECIES_WILD_MARMOT = 'wild_marmot';
    const ANIMAL_SPECIES_WILD_IBEX = 'wild_ibex';
    const ANIMAL_SPECIES_WILD_CHAMOIS = 'wild_chamois';
    const ANIMAL_SPECIES_WILD_SQUIRREL = 'wild_squirrel';
    const ANIMAL_SPECIES_WILD_BAT = 'wild_bat';
    const ANIMAL_SPECIES_WILD_BISON = 'wild_bison';
    const ANIMAL_SPECIES_WILD_OTTER = 'wild_otter';
    const ANIMAL_SPECIES_WILD_RACCOON = 'wild_raccoon';
    const ANIMAL_SPECIES_WILD_FALCON = 'wild_falcon';
    const ANIMAL_SPECIES_WILD_EAGLE = 'wild_eagle';
    const ANIMAL_SPECIES_WILD_OTHER = 'wild_other';
    const ANIMAL_SPECIES_WILD_AQUATIC_DELPHINID = 'wild_aquatic_delphinid';
    const ANIMAL_SPECIES_WILD_AQUATIC_WHALE = 'wild_aquatic_whale';
    const ANIMAL_SPECIES_WILD_AQUATIC_SEAL = 'wild_aquatic_seal';
    const ANIMAL_SPECIES_WILD_AQUATIC_WALRUS = 'wild_aquatic_walrus';
    const ANIMAL_SPECIES_WILD_AQUATIC_OTHER = 'wild_aquatic_other';

    const ANIMAL_SPECIES = [
        self::ANIMAL_SPECIES_PET_DOG_OTHER,
        self::ANIMAL_SPECIES_PET_DOG_SHEPERD,
        self::ANIMAL_SPECIES_PET_DOG_BORDERCOLLIE,
        self::ANIMAL_SPECIES_PET_DOG_GOLDENRETRIEVER,
        self::ANIMAL_SPECIES_PET_DOG_MALINOIS,
        self::ANIMAL_SPECIES_PET_DOG_LABRADOR,
        self::ANIMAL_SPECIES_PET_DOG_BOUVIER,
        self::ANIMAL_SPECIES_PET_DOG_BULLDOG,
        self::ANIMAL_SPECIES_PET_DOG_ROTTWEILER,
        self::ANIMAL_SPECIES_PET_DOG_JACKRUSSEL,
        self::ANIMAL_SPECIES_PET_DOG_CHIHUAHUA,
        self::ANIMAL_SPECIES_PET_DOG_YORKSHIRE,
        self::ANIMAL_SPECIES_PET_DOG_BICHON,
        self::ANIMAL_SPECIES_PET_DOG_SHIHTZU,
        self::ANIMAL_SPECIES_PET_DOG_STAFF,
        self::ANIMAL_SPECIES_PET_DOG_PUG,
        self::ANIMAL_SPECIES_PET_DOG_KINGCHARLES,
        self::ANIMAL_SPECIES_PET_DOG_COCKER,
        self::ANIMAL_SPECIES_PET_DOG_BOXER,
        self::ANIMAL_SPECIES_PET_DOG_HUSKY,
        self::ANIMAL_SPECIES_PET_DOG_DACHSHUND,
        self::ANIMAL_SPECIES_PET_DOG_DALMATIAN,
        self::ANIMAL_SPECIES_PET_DOG_SMALL,
        self::ANIMAL_SPECIES_PET_DOG_MEDIUM,
        self::ANIMAL_SPECIES_PET_DOG_LARGE,
        self::ANIMAL_SPECIES_PET_CAT_OTHER,
        self::ANIMAL_SPECIES_PET_CAT_EUROPEAN,
        self::ANIMAL_SPECIES_PET_CAT_BENGAL,
        self::ANIMAL_SPECIES_PET_CAT_PERSIAN,
        self::ANIMAL_SPECIES_PET_CAT_SIAMESE,
        self::ANIMAL_SPECIES_PET_CAT_CHARTREUX,
        self::ANIMAL_SPECIES_PET_CAT_MAINECOON,
        self::ANIMAL_SPECIES_PET_CAT_SPHYNX,
        self::ANIMAL_SPECIES_PET_CAT_SHORTHAIR,
        self::ANIMAL_SPECIES_PET_CAT_SIBERIAN,
        self::ANIMAL_SPECIES_PET_CAT_NORWEGIAN,
        self::ANIMAL_SPECIES_PET_CAT,
        self::ANIMAL_SPECIES_PET_RABBIT,
        self::ANIMAL_SPECIES_PET_FERRET,
        self::ANIMAL_SPECIES_PET_RODENT,
        self::ANIMAL_SPECIES_PET_BIRD,
        self::ANIMAL_SPECIES_PET_EQUINE,
        self::ANIMAL_SPECIES_PET_FISH,
        self::ANIMAL_SPECIES_PET_EXOTIC,
        self::ANIMAL_SPECIES_LIVESTOCK_FARMYARD,
        self::ANIMAL_SPECIES_LIVESTOCK_FARM,
        self::ANIMAL_SPECIES_CIRCUS_OTHER,
        self::ANIMAL_SPECIES_WILD_WOLF,
        self::ANIMAL_SPECIES_WILD_HEDGEHOG,
        self::ANIMAL_SPECIES_WILD_HART,
        self::ANIMAL_SPECIES_WILD_HIND,
        self::ANIMAL_SPECIES_WILD_FAWN,
        self::ANIMAL_SPECIES_WILD_BOAR,
        self::ANIMAL_SPECIES_WILD_FOX,
        self::ANIMAL_SPECIES_WILD_DUCK,
        self::ANIMAL_SPECIES_WILD_BEAVER,
        self::ANIMAL_SPECIES_WILD_HARE,
        self::ANIMAL_SPECIES_WILD_NUTRIA,
        self::ANIMAL_SPECIES_WILD_RODENT,
        self::ANIMAL_SPECIES_WILD_CAT,
        self::ANIMAL_SPECIES_WILD_BEAR,
        self::ANIMAL_SPECIES_WILD_LYNX,
        self::ANIMAL_SPECIES_WILD_ROE,
        self::ANIMAL_SPECIES_WILD_MARMOT,
        self::ANIMAL_SPECIES_WILD_IBEX,
        self::ANIMAL_SPECIES_WILD_CHAMOIS,
        self::ANIMAL_SPECIES_WILD_SQUIRREL,
        self::ANIMAL_SPECIES_WILD_BAT,
        self::ANIMAL_SPECIES_WILD_BISON,
        self::ANIMAL_SPECIES_WILD_OTTER,
        self::ANIMAL_SPECIES_WILD_RACCOON,
        self::ANIMAL_SPECIES_WILD_FALCON,
        self::ANIMAL_SPECIES_WILD_EAGLE,
        self::ANIMAL_SPECIES_WILD_OTHER,
        self::ANIMAL_SPECIES_WILD_AQUATIC_DELPHINID,
        self::ANIMAL_SPECIES_WILD_AQUATIC_WHALE,
        self::ANIMAL_SPECIES_WILD_AQUATIC_SEAL,
        self::ANIMAL_SPECIES_WILD_AQUATIC_WALRUS,
        self::ANIMAL_SPECIES_WILD_AQUATIC_OTHER,
    ];

    // End of class
}
