<?php

namespace Modules\Common\Entities;

use Illuminate\Database\Eloquent\Model;

use Backpack\CRUD\app\Models\Traits\CrudTrait;

use Modules\Common\Entities\Presenters\AbusePresenter;
use Modules\Common\Entities\Relationships\AbuseRelationships;
use Modules\Common\Entities\Scopes\AbuseScopes;

use Carbon\Carbon;


class Abuse extends Model
{

    /***************************************************************************
     * Traits
     **************************************************************************/
    use AbuseRelationships,
        AbuseScopes,
        AbusePresenter,
        CrudTrait;

    /***************************************************************************
     * Constants
     **************************************************************************/
    const MORPH_NAME = 'abusable';

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $fillable = ['user_id', 'type', 'comment', 'state'];

    /***************************************************************************
     * Accessors
     **************************************************************************/
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->timezone('Europe/Brussels');
    }

    /***************************************************************************
     * Type Values
     **************************************************************************/
    const TYPE_INAPPROPRIATE_CONTENT = 'inappropriate_content';
    const TYPE_OTHER = 'other';

    const TYPES = [
        self::TYPE_INAPPROPRIATE_CONTENT,
        self::TYPE_OTHER,
    ];

    /***************************************************************************
     * State Values
     **************************************************************************/
    const STATE_WAITING = 'waiting';
    const STATE_DONE = 'done';

    const STATES = [
        self::STATE_WAITING,
        self::STATE_DONE,
    ];

    // End of class
}
