<?php

use Modules\Common\Entities\User;
use Faker\Generator as Faker;
use Modules\Common\Entities\PremiumCity;

$factory->define(User::class, function (Faker $faker) {
    return [
        'email' => $faker->unique()->safeEmail,
        'password' => bcrypt('password'),
        'first_name' => $faker->firstName,
        'last_name' => $faker->lastName,
        'gender' => $faker->optional()->randomElement(User::GENDERS),
        'date_of_birth' => $faker->date,
        'phone' => $faker->e164PhoneNumber,
        'phone_is_private' => $faker->boolean,
        'address' => $faker->optional()->address,
        'address_is_private' => $faker->boolean,
        'location_zipcode' => $faker->optional()->postcode,
        'location_country' => $faker->randomElement(PremiumCity::COUNTRIES),
    ];
});
