<?php

use Faker\Generator as Faker;

use Modules\Common\Entities\Animal;
use Modules\Common\Entities\RegisteredAnimal;
use Modules\Common\Entities\User;

$factory->define(RegisteredAnimal::class, function (Faker $faker) {
    return [
        'user_id' => User::all()->random()->id,
        'name' => $faker->name,
        'animal_species' => $faker->randomElement(Animal::ANIMAL_SPECIES),
        'identification_type' => $faker->optional()->randomElement(Animal::IDENTIFICATION_TYPES),
        'identification_number' => $faker->optional()->isbn10(),
        'comment' => $faker->optional()->text(60),
    ];
});
