<?php

namespace Modules\Common\Database\Seeders\Test;

use Illuminate\Database\Seeder;
use Modules\Common\Entities\PremiumCity;
use Modules\Common\Entities\User;


class UsersTestTableSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // User 1 (Premium)
        factory(User::class)->create([
            'id' => 1,
            'email' => 'perfect.guy@example.org',
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
            'last_name' => 'Guy',
            'first_name' => 'Perfect',
            'gender' => User::GENDER_MALE,
            'date_of_birth' => '1990-02-03',
            'phone' => '0412111111',
            'phone_is_private' => false,
            'address' => 'Here',
            'address_is_private' => false,
            'location_zipcode' => '7140',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
        ]);

        // User 2
        factory(User::class)->create([
            'id' => 2,
            'email' => 'not.verified@example.org',
            'email_verified_at' => null,
            'last_name' => 'Verified',
            'first_name' => 'Not',
        ]);

        // User 3 (Not premium)
        factory(User::class)->create([
            'id' => 3,
            'email' => 'tony.montana@example.org',
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
            'last_name' => 'Montana',
            'first_name' => 'Tony',
            'phone' => '0412222222',
            'phone_is_private' => false,
            'address' => 'Here 3',
            'address_is_private' => false,
            'location_zipcode' => '7180',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
        ]);

        // User 4 (Organization)
        factory(User::class)->create([
            'id' => 4,
            'email' => 'big.boss@example.org',
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
            'last_name' => 'Boss',
            'first_name' => 'Big',
            'phone' => '0412333333',
            'phone_is_private' => false,
            'address' => 'Here 4',
            'address_is_private' => false,
            'location_zipcode' => '7180',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
            'account_type' => User::ACCOUNT_TYPE_ORGANIZATION,
            'is_verified' => true,
        ]);

        // User 5 (Organization Access)
        factory(User::class)->create([
            'id' => 5,
            'email' => 'simple.employee@example.org',
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
            'last_name' => 'Simple',
            'first_name' => 'Employee',
            'phone' => '0412444444',
            'phone_is_private' => false,
            'address' => 'Here 5',
            'address_is_private' => false,
            'location_zipcode' => '7160',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
            'account_type' => User::ACCOUNT_TYPE_ACCESS,
            'extras' => ['organization_id' => 4],
        ]);

        // User 6 (Blocked Account)
        factory(User::class)->create([
            'id' => 6,
            'email' => 'blocked.account@example.org',
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
            'last_name' => 'Blocked',
            'first_name' => 'Account',
            'phone' => '0412666666',
            'phone_is_private' => false,
            'address' => 'Here 6',
            'address_is_private' => false,
            'location_zipcode' => '7160',
            'location_country' => PremiumCity::COUNTRY_BELGIUM,
            'is_blocked' => 1,
        ]);
    }

    // End of class
}
