<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

use Modules\Common\Entities\Abuse;


class CreateAbusesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('abuses', function (Blueprint $table) {
            $table->bigIncrements('id');
            
            $table->unsignedBigInteger('user_id');
            
            $table->unsignedBigInteger('abusable_id');
            $table->string('abusable_type');
            
            $table->string('type', 30)->default(Abuse::TYPE_OTHER);
            $table->text('comment')->nullable();
            
            $table->string('state', 20)->default(Abuse::STATE_WAITING);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('abuses');
    }
}
