<?php

namespace Modules\Blog\Tests\Feature\Database;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

use Modules\Blog\Entities\Post;
use Modules\Blog\Entities\Tag;

use Schema;

class TagTest extends TestCase
{
    use RefreshDatabase;
        
    /***************************************************************************
     * Set Up
     **************************************************************************/
    public function setUp() : void
    {
        parent::setUp();
        
        $this->artisan('db:seed', ['--class' => 'Modules\Blog\Database\Seeders\Test\TestDatabaseSeeder']);
    }
    
    /***************************************************************************
     * Tests
     **************************************************************************/   
    public function testTagsTableHasExpectedColumns() 
    {        
        $this->assertTrue(
            Schema::hasColumns('tags', [
                'id', 'name', 'slug',
            ])
        );
    }
    
    public function testTagBelongsToManyPosts() 
    {        
        $tag = Tag::find(1);
        $post = Post::find(1);
        $otherPost = Post::find(3);
        
        $this->assertInstanceOf('Illuminate\Database\Eloquent\Collection', $tag->posts);
        $this->assertTrue($tag->posts->contains($post));
        $this->assertFalse($tag->posts->contains($otherPost));
    }
    
    // End of class
}