@extends('blog::_layouts.master')

@section('title', $post->title)

@section('content')


{{-- Header --}}
<header class="pt-24">
  <div class="mx-auto container px-3 py-16">
    <div class="w-full text-center">
      <h1 class="my-4 text-5xl font-bold leading-tight">{{ $post->title }}</h1>
      <div class="mt-4 mb-2">
        @foreach($post->tags as $tag)
        <span class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold text-gray-700 mr-2 mb-2">{{ $tag->name }}</span>
        @endforeach
      </div>
      <p class="text-white text-base"><i class="fa fa-calendar"></i> {{ $post->createdAtFormatted }}</p>
    </div>
  </div>
</header>


{{-- Starting gradient --}}
@include('landing::_layouts/_partials/gradient-start', ['fill' => '#ffffff'])


{{-- Post Detail --}}
<section class="bg-white py-32 text-gray-800 text-xl border-b">
  <div class="mx-auto container">
    <p class="font-bold">{{ $post->excerpt }}</p>
    <div class="mt-4">
      <img class="shadow w-full object-cover rounded-xl mb-2 float-right" src="{{ $post->getFirstMediaUrl() }}" alt="" style="height: 500px; width: 500px;">
      <div>{!! $post->body !!}</div>
    </div>
    <div class="clear-both"></div>
  </div>
</section>


{{-- Latest Posts --}}
@include('landing::home/_includes/latest_posts')


{{-- Ending gradient --}}
@include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection